<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Staff</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href=" <?= site_url('karyawan') ?>">Staff</a></li>
                    <li class="breadcrumb-item active">Data Staff</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<section class="content">
    <?php $this->view('message') ?>
    <div class="container-fluid">
        <div class="col-12">
            <div class="card">
                <?php if ($this->fungsi->user_login()->level == 1) {  ?>
                    <div class="card-header">
                        <a href="<?= site_url('karyawan/update') ?>" class="btn btn-Danger" onclick="return confirm('Apakah anda yakin?')">
                            <i class="fas fa-minus-circle"></i> <b>Reset Commision</b>
                        </a> &nbsp; &nbsp;
                        <a href="<?= site_url('karyawan/export_excel') ?>" class="btn btn-warning ">
                            <i class="fas fa-download"></i> <b>Export Report</b>
                        </a> &nbsp; &nbsp;
                        <a href="<?= site_url('karyawan/add') ?>" class="btn btn-primary float-right">
                            <i class="fa fa-user-plus"></i> <b>Create</b>
                        </a>
                    </div>
                <?php } ?>
                <!-- /.card-header -->
                <div class="card-body">
                    <table id="example2" class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Gender</th>
                                <th>Phone</th>
                                <th>Address</th>
                                <th>Position</th>
                                <th>Commision</th>
                                <th>Pinjaman</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1;
                            foreach ($row->result() as $key => $data) { ?>
                                <tr>
                                    <td><?= $no++ ?> </td>
                                    <td><?= $data->name ?> </td>
                                    <td><?= $data->gender == 'L' ? "Laki Laki" : "Perempuan" ?> </td>
                                    <td><?= $data->phone ?> </td>
                                    <td><?= $data->address ?> </td>
                                    <td><?= $data->position ?> </td>
                                    <td><?= indo_currency($data->commision) ?> </td>
                                    <td><?= indo_currency($data->pinjaman) ?> </td>
                                    <td class="text-center" width="150px">
                                        <a href="<?= site_url('karyawan/edit/' . $data->karyawan_id) ?>" class="btn btn-primary btn-xs">
                                            <i class=" fa fa-edit"></i><b>Update</b>
                                        </a>
                                        <?php if ($this->fungsi->user_login()->level == 1) {  ?>
                                            <a href="<?= site_url('karyawan/del/' . $data->karyawan_id) ?>" class="btn btn-danger btn-xs" onclick="return confirm('Apakah anda yakin?')">
                                                <i class="fa fa-trash"></i><b>Delete</b>
                                            </a>
                                        <?php } ?>

                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->