<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Pinjaman_m extends CI_Model
{

    public function get($id = null)
    {
        $this->db->from('p_pinjaman');
        if ($id != null) {
            $this->db->where('pinjaman_id', $id);
        }
        $query = $this->db->get();
        return $query;
    }
    public function del($id)
    {
        $this->db->where('pinjaman_id', $id);
        $this->db->delete('p_pinjaman');
    }

    public function get_karyawan()
    {
        $this->db->from('karyawan');
        $this->db->order_by('karyaawan_id', 'desc');
        $query = $this->db->get();
        return $query;
    }

    // INDEX PINJAM
    public function get_pinjam($id = null)
    {
        $this->db->select('p_pinjaman.pinjaman_id,  karyawan.name as karyawan_name, p_pinjaman.pinjaman as utang, type, date, keterangan, karyawan.karyawan_id');
        $this->db->from('p_pinjaman');
        $this->db->join('karyawan', 'p_pinjaman.karyawan_id = karyawan.karyawan_id');
        $this->db->where('type', 'pinjam');
        $this->db->order_by('pinjaman_id', 'desc');
        $query = $this->db->get();
        return $query;
    }

    // TAMBAH PINJAM
    public function add_pinjam($post)
    {
        $params = [
            'karyawan_id' => $post['karyawan_id'],
            'pinjaman' => $post['pinjaman'],
            'type' => 'pinjam',
            'keterangan' => $post['keterangan'],
            'date' => $post['date'],
            'user_id' => $this->session->userdata('user_id'),
        ];
        $this->db->insert('p_pinjaman', $params);
    }

    // INDEX BAYAR
    public function get_bayar($id = null)
    {
        $this->db->select('p_pinjaman.pinjaman_id,  karyawan.name as karyawan_name, p_pinjaman.pinjaman as utang, type, date, keterangan, karyawan.karyawan_id');
        $this->db->from('p_pinjaman');
        $this->db->join('karyawan', 'p_pinjaman.karyawan_id = karyawan.karyawan_id');
        $this->db->where('type', 'bayar');
        $this->db->order_by('pinjaman_id', 'desc');
        $query = $this->db->get();
        return $query;
    }

    // TAMBAH BAYAR
    public function add_bayar($post)
    {
        $params = [
            'karyawan_id' => $post['karyawan_id'],
            'pinjaman' => $post['pinjaman'],
            'type' => 'bayar',
            'keterangan' => $post['keterangan'],
            'date' => $post['date'],
            'user_id' => $this->session->userdata('user_id'),
        ];
        $this->db->insert('p_pinjaman', $params);
    }
}
