<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Catatankerja_m extends CI_Model
{

    public function get($id = null)
    {
        $this->db->from('p_catatankerja');
        if ($id != null) {
            $this->db->where('catatan_id', $id);
        }
        $query = $this->db->get();
        return $query;
    }

    // DELETE KELUHAN
    public function del($id)
    {
        $this->db->where('catatan_id', $id);
        $this->db->delete('p_catatankerja');
    }

    // INDEX KELUHAN
    public function get_catatan($id = null)
    {
        $this->db->select('p_catatankerja.catatan_id, karyawan.name as karyawan_name, catatankerja, keterangan, date, karyawan.karyawan_id');
        $this->db->from('p_catatankerja');
        $this->db->join('karyawan', 'p_catatankerja.karyawan_id = karyawan.karyawan_id');
        $query = $this->db->get();
        return $query;
    }

    // TAMBAH KELUHAN
    public function add_catatan($post)
    {
        $params = [
            'karyawan_id' => $post['karyawan_id'],
            'catatankerja' => $post['catatankerja'],
            'keterangan' => $post['keterangan'],
            'date' => $post['date'],
            'user_id' => $this->session->userdata('user_id'),
        ];
        $this->db->insert('p_catatankerja', $params);
    }
}
