<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Customer_m extends CI_Model
{
    var $table = 'customer';
    var $column_order = array(null, 'name', 'gender', 'phone', 'address', 'category_id', 'point', 'created');
    var $column_search = array('customer.name', 'gender', 'phone', 'address', 'c_category.name', 'point');
    var $order = ['created' => 'desc'];

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    private function getDatatableQuery()
    {
        $this->db->select('customer.*,  c_category.name as category_name');
        $this->db->join('c_category', 'c_category.category_id = customer.category_id');
        $this->db->from($this->table);
        $i = 0;

        foreach ($this->column_search as $item) {
            if ($this->input->post('search')['value']) {
                if ($i === 0) {
                    $this->db->group_start();
                    $this->db->like($item, $this->input->post('search')['value']);
                } else {
                    $this->db->or_like($item, $this->input->post('search')['value']);
                }

                if (count($this->column_search) - 1 === $i)
                    $this->db->group_end();
            }

            $i++;
        }

        if (isset($_POST['order'])) {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables()
    {
        $this->getDatatableQuery();
        if ($this->input->post('length') != -1)
            $this->db->limit($this->input->post('length'), $this->input->post('start'));
        $query = $this->db->get();
        // log_message('debug', json_encode($query));
        return $query->result();
    }

    function count_filtered()
    {
        $this->getDatatableQuery();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all()
    {
        $this->db->from($this->table);
        return $this->db->count_all_results();
    }

    // menampilkan data customer
    public function get($id = null)
    {
        $this->db->select('customer.*,  c_category.name as category_name');
        $this->db->from('customer');
        $this->db->join('c_category', 'c_category.category_id = customer.category_id');
        if ($id != null) {
            $this->db->where('customer_id', $id);
        }
        $query = $this->db->get();
        return $query;
    }

    // menghapus data customer
    public function del($id)
    {

        $this->db->where('customer_id', $id);
        $this->db->delete('customer');
    }

    // menambah data customer
    public function add($post)
    {
        $params = [
            'name' => $post['customer_name'],
            'gender' => $post['gender'],
            'phone' => $post['phone'],
            'address' => $post['address'],
            'category_id' => $post['category'],
        ];
        $this->db->insert('customer', $params);
    }

    // mengedit data customer
    public function edit($post)
    {
        $params = [
            'name' => $post['customer_name'],
            'gender' => $post['gender'],
            'phone' => $post['phone'],
            'address' => $post['address'],
            'category_id' => $post['category'],
            'updated' => date('Y-m-d H:i:s')
        ];
        $this->db->where('customer_id', $post['id']);
        $this->db->update('customer', $params);
    }

    public function view_customer()
    {
        $this->db->select('*, c_category.name as category_name, customer.name as cust_name ');
        $this->db->from('customer');
        $this->db->join('c_category', 'customer.category_id = c_category.category_id');
        return $this->db->get()->result(); // Tampilkan data transaksi sesuai tanggal yang diinput oleh user pada filter  
    }
}