<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Stock_bahan_m extends CI_Model
{

    public function get($id = null)
    {
        $this->db->from('t_stock_bahan');
        if ($id != null) {
            $this->db->where('stock_id', $id);
        }
        $query = $this->db->get();
        return $query;
    }
    public function del($id)
    {
        $this->db->where('stock_id', $id);
        $this->db->delete('t_stock_bahan');
    }

    // menampilkan stock
    public function get_stock_in($id = null)
    {
        $this->db->select('t_stock_bahan.stock_id,  p_bahan.bahan_name as bahan_name, qty, date, detail, p_bahan.bahan_id');
        $this->db->from('t_stock_bahan');
        $this->db->join('p_bahan', 't_stock_bahan.bahan_id = p_bahan.bahan_id');
        $this->db->where('type', 'in');
        $this->db->order_by('stock_id', 'desc');
        $query = $this->db->get();
        return $query;
    }
    public function add_stock_in($post)
    {
        $params = [
            'bahan_id' => $post['bahan_id'],
            'type' => 'in',
            'detail' => $post['detail'],
            'qty' => $post['qty'],
            'date' => $post['date'],
            'user_id' => $this->session->userdata('user_id'),
        ];
        $this->db->insert('t_stock_bahan', $params);
    }

    public function get_stock_out()
    {
        $this->db->from('t_stock_bahan');
        $this->db->join('p_bahan', 't_stock_bahan.bahan_id = p_bahan.bahan_id');
        $this->db->where('type', 'out');
        $this->db->order_by('stock_id', 'desc');
        $query = $this->db->get();
        return $query;
    }
    public function add_stock_out($post)
    {
        $params = [
            'bahan_id' => $post['bahan_id'],
            'type' => 'out',
            'detail' => $post['detail'],
            'qty' => $post['qty'],
            'date' => $post['date'],
            'user_id' => $this->session->userdata('user_id'),
        ];
        $this->db->insert('t_stock_bahan', $params);
    }
}
