<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Sales extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
      	check_not_login();
        $this->load->model('Transaction/Sales_m');
    }

    // VIEW DATA INDEX SALES SERVICE
    public function index()
    {
        check_kasir();
        $this->load->model(['Customer/Customer_m', 'Customer/C_Category_m', 'Products/Services_m', 'Karyawan_m', 'Bahan/Bahan_m']);
        $customer = $this->Customer_m->get()->result();
        $query_category = $this->C_Category_m->get();
        $cashier = $this->Karyawan_m->get_cashier()->result();
        $terapis = $this->Karyawan_m->get_terapis()->result();
        $bahan = $this->Bahan_m->get()->result();
        $services = $this->Services_m->get()->result();
        $cart = $this->Sales_m->get_cart();
        $data = array(
            'customer' => $customer,
            'cashier' => $cashier,
            'terapis' => $terapis,
            'bahan' => $bahan,
            'services' => $services,
            'query_category' => $query_category,
            'cart' => $cart,
            'invoice' => $this->Sales_m->invoice_no(),
        );
        $this->template->load('template', 'Transaction/Sales_form', $data);
        $this->load->view('datatables');
    }
    // PROCESS ADD/EDIT/PAYMENT
    public function process()
    {
        $data = $this->input->post(null, TRUE);
        if (isset($_POST['add_cart_bahan'])) {
            $this->Sales_m->add_cart_bahan($data);
            if ($this->db->affected_rows() > 0) {
                $params = array("success" => true);
            } else {
                $params = array("success" => false);
            }
            echo json_encode($params);
        }
        if (isset($_POST['add_cart_services'])) {
            $this->Sales_m->add_cart_services($data);
            if ($this->db->affected_rows() > 0) {
                $params = array("success" => true);
            } else {
                $params = array("success" => false);
            }
            echo json_encode($params);
        }
        if (isset($_POST['edit_cart'])) {
            $this->Sales_m->edit_cart($data);
            if ($this->db->affected_rows() > 0) {
                $params = array("success" => true);
            } else {
                $params = array("success" => false);
            }
            echo json_encode($params);
        }
        if (isset($_POST['process_payment'])) {
            $sale_id = $this->Sales_m->add_sale($data);
            $cart = $this->Sales_m->get_cart()->result();
            $row = [];
            foreach ($cart as $c => $value) {
                array_push(
                    $row,
                    array(
                        'sale_id' => $sale_id,
                        'services_id' => $value->services_id,
                        'bahan_id' => $value->bahan_id,
                        'terapis_id' => $value->terapis_id,
                        'detail_price' => $value->cart_price,
                        'qty' => $value->qty,
                        'commision' => $value->commision,
                        'discount_item' => $value->discount_item,
                        'total' => $value->total,
                    )
                );
            }
            $this->Sales_m->add_sale_detail($row);
            $this->Sales_m->del_cart(['user_id' => $this->session->userdata('user_id')]);
            if ($this->db->affected_rows() > 0) {
                $params = array("success" => true, "sale_id" => $sale_id);
            } else {
                $params = array("success" => false);
            }
            echo json_encode($params);
        }
    }

    // GET CART DATA
    function cart_data()
    {
        $cart = $this->Sales_m->get_cart();
        $data['cart'] = $cart;
        $this->load->view('Transaction/Cart_data', $data);
    }

    // DELETE CART DATA
    public function cart_del()
    {
        if (isset($_POST['cancel_payment'])) {
            $this->Sales_m->del_cart(['user_id' => $this->session->userdata('user_id')]);
        } else {
            $cart_id = $this->input->post('cart_id');
            $this->Sales_m->del_cart(['cart_id' => $cart_id]);
        }

        if ($this->db->affected_rows() > 0) {
            $params = array("success" => true);
        } else {
            $params = array("success" => false);
        }
        echo json_encode($params);
    }
    // END DELETE CART

    // CETAK CART
    public function cetak($id)
    {
        $data = array(
            'sale' => $this->Sales_m->get_sale($id)->row(),
            'sale_detail' => $this->Sales_m->get_sale_detail($id)->result(),
        );
        $this->load->view('Transaction/Receipt_print', $data);
    }
    // END CETAK CART

    // DELETE REPORT SALE
    public function del($id)
    {
        $this->Sales_m->del_sale($id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil Dihapus');
            redirect('Report');
        } else {
            $this->session->set_flashdata('error', 'Data Gagal Dihapus');
            redirect('Report');
        }
    }
    // END DELETE REPORT SALE

    // DELETE REPORT SALE
    public function delrefund($id)
    {
        $this->Sales_m->del_refund($id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil Dihapus');
            redirect('refund');
        } else {
            $this->session->set_flashdata('error', 'Data Gagal Dihapus');
            redirect('refund');
        }
    }
    // END DELETE REPORT SALE

}
