<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Karyawan extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        check_not_login();
        $this->load->model('Karyawan_m');
    }

    public function index()
    {
        $data['row'] = $this->Karyawan_m->get();
        $this->template->load('template', 'Karyawan/Karyawan_data', $data);
        $this->load->view('datatables');
    }

    // FORM DELETE
    public function del($id)
    {
        $this->Karyawan_m->del($id);
        if ($this->db->affected_rows() > 0) {
            echo "<script>alert('Data berhasil dihapus');</script>";
        }
        echo "<script>window.location='" . site_url('Karyawan') . "';</script>";
    }
    // FORM ADD
    public function add()
    {
        $karyawan = new stdClass();
        $karyawan->karyawan_id = null;
        $karyawan->name = null;
        $karyawan->gender = null;
        $karyawan->phone = null;
        $karyawan->address = null;
        $karyawan->position = null;
        $data = array(
            'page' => 'add',
            'row' => $karyawan
        );
        $this->template->load('template', 'Karyawan/Karyawan_form', $data);
    }

    // form edit
    public function edit($id)
    {
        $query = $this->Karyawan_m->get($id);
        if ($query->num_rows() > 0) {
            $karyawan = $query->row();
            $data = array(
                'page' => 'edit',
                'row' => $karyawan
            );
            $this->template->load('template', 'Karyawan/Karyawan_form', $data);
        } else {
            echo "<script>alert('Data tidak ditemukan');";
            echo "window.location='" . site_url('Karyawan') . "';</script>";
        }
    }

    // FORM PROSES
    public function process()
    {
        $post = $this->input->post(null, True);
        if (isset($_POST['add'])) {
            $this->Karyawan_m->add($post);
        } else if (isset($_POST['edit'])) {
            $this->Karyawan_m->edit($post);
        }
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil Disimpan');
        }
        echo "<script>window.location='" . site_url('Karyawan') . "';</script>";
    }
    public function update()
    {
        $this->Karyawan_m->update();
        if ($this->db->affected_rows() > 0) {
            echo "<script>alert('Commision berhasil direset');</script>";
        }
        echo "<script>window.location='" . site_url('Karyawan') . "';</script>";
    }

    public function export_excel()
    {
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel.php';
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->getProperties()->setCreator("Podiy Beauty");
        $objPHPExcel->getProperties()->setLastModifiedBy("Podiy Beauty");
        $objPHPExcel->getProperties()->setTitle("Data Stock Product");
        $objPHPExcel->getProperties()->setSubject("");
        $objPHPExcel->getProperties()->setDescription("");

        $style_col = array(
            'font' => array('bold' => true),
            'aligment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
            ),
            'borders' => array(
                'top' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'right' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'left' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
            )
        );

        $product = $this->Karyawan_m->view_karyawan(); // Panggil fungsi view_by_date yang ada di TransaksiModel            

        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A1', "DATA STAFF");
        $objPHPExcel->getActiveSheet()->mergeCells('A1:H1');
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->setCellValue('A2', "NO");
        $objPHPExcel->getActiveSheet()->setCellValue('B2', "Name");
        $objPHPExcel->getActiveSheet()->setCellValue('C2', "Gender");
        $objPHPExcel->getActiveSheet()->setCellValue('D2', "Phone");
        $objPHPExcel->getActiveSheet()->setCellValue('E2', "Address");
        $objPHPExcel->getActiveSheet()->setCellValue('F2', "Position");
        $objPHPExcel->getActiveSheet()->setCellValue('G2', "Commision");
        $objPHPExcel->getActiveSheet()->setCellValue('H2', "Pinjaman");

        $objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('C2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('D2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('E2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('F2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('G2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('H2')->applyFromArray($style_col);


        $baris = 3;
        $x = 1;
        foreach ($product as $data) {
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $baris, $x);
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $baris, $data->name);
            $objPHPExcel->getActiveSheet()->setCellValue('C' . $baris, $data->gender);
            $objPHPExcel->getActiveSheet()->setCellValue('D' . $baris, $data->phone);
            $objPHPExcel->getActiveSheet()->setCellValue('E' . $baris, $data->address);
            $objPHPExcel->getActiveSheet()->setCellValue('F' . $baris, $data->position);
            $objPHPExcel->getActiveSheet()->setCellValue('G' . $baris, $data->commision);
            $objPHPExcel->getActiveSheet()->setCellValue('H' . $baris, $data->pinjaman);

            $x++;
            $baris++;
        }
        $filename = "Data Staff".".xlsx";
        $objPHPExcel->getActiveSheet()->setTitle("Data Staff");

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename=' . $filename);
        header('Cache-Control: max-age=0');

        $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $writer->save('php://output');

        exit;
    }
}
