<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">Staff</li>
                    <li class="breadcrumb-item"><a href="<?= site_url('Rpotkaryawan/Keluhan') ?>">Keluhan Customer</a></li>
                    <li class="breadcrumb-item active">Add</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- /.container-fluid -->
</section>
<section class="content">
    <div class="container-fluid">
        <div class="col-12">
            <div class="card card-primary">
                <div class="card-header">
                    <span class="float-left">
                        <h2> Keluhan Customer</h2>
                    </span>
                    <a href="<?= site_url('Rpotkaryawan/Keluhan/') ?>" class="btn btn-info float-right">
                        <i class="fa fa-undo"></i> Back
                    </a>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <!-- FORM -->
                    <div class="col-md-4">
                        <form action="<?= site_url('Rpotkaryawan/Keluhan/process') ?>" method="post">
                            <div class="card-body">
                                <div class="form-group ">
                                    <label>Date *</label>
                                    <input type="date" name="date" value="<?= date('Y-m-d') ?>" class="form-control">
                                </div>
                                <div>
                                    <label for="customer_name">Customer Name *</label>
                                </div>
                                <div class="form-group input-group ">
                                    <input type="hidden" name="customer_id" id="customer_id">
                                    <input type="text" name="customer_name" id="customer_name" class="form-control" required autofocus>
                                    <span class="input-group-append">
                                        <button type="button" class="btn btn-info btn-default" data-toggle="modal" data-target="#mod_customer">
                                            <i class="fas fa-search"></i></i>
                                        </button>
                                    </span>
                                </div>
                                <div>
                                    <label for="karyawan_name">Karyawan Name *</label>
                                </div>
                                <div class="form-group input-group ">
                                    <input type="hidden" name="karyawan_id" id="karyawan_id">
                                    <input type="text" name="karyawan_name" id="karyawan_name" class="form-control" required autofocus>
                                    <span class="input-group-append">
                                        <button type="button" class="btn btn-info btn-default" data-toggle="modal" data-target="#karyawan">
                                            <i class="fas fa-search"></i></i>
                                        </button>
                                    </span>
                                </div>
                                <div class="form-group ">
                                    <label for="keluhan">Keluhan *</label>
                                    <textarea class="form-control" name="keluhan" id="keluhan" required></textarea>
                                </div>
                                <div class="form-group ">
                                    <label for="solusi">Solusi *</label>
                                    <textarea class="form-control" name="solusi" id="solusi" required></textarea>
                                </div>
                            </div>
                    </div>
                </div>
            </div>
            <!-- /.card-body -->
            <div class="card-footer form-group">
                <button type="submit" name="keluhan_add" class="btn btn-primary">Submit </button>
                <button type="reset" class="btn btn-info float-right">Reset</button>
            </div>
            </form>
        </div>
        <!-- End Form -->
    </div>
    <!-- /.card-body -->
    </div>
    <!-- /.card -->
    </div>
    <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->

<!-- Modal Karyawan -->
<div class="modal fade" id="karyawan">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Select Karyawan</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table id="example2" class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Position</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($karyawan as $k => $data) { ?>
                            <tr>
                                <td><?= $data->name ?> </td>
                                <td class="text-right"><?= $data->position ?> </td>
                                <td class="text-center" style="width:15%">
                                    <button class="btn btn-xs btn-info" id="select_karyawan" data-id="<?= $data->karyawan_id ?>" data-name="<?= $data->name ?>">
                                        <i class="fa fa-check">
                                        </i>Select
                                    </button>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-- Modal Customer -->
<div class="modal fade" id="mod_customer">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Select Customer</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table id="example3" class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Phone</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($customer as $c => $data) { ?>
                            <tr>
                                <td><?= $data->name ?> </td>
                                <td class="text-right"><?= $data->phone ?> </td>
                                <td class="text-center" style="width:15%">
                                    <button class="btn btn-xs btn-info" id="sel_customer" data-id="<?= $data->customer_id ?>" data-name="<?= $data->name ?>">
                                        <i class="fa fa-check">
                                        </i>Select
                                    </button>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->