<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Report Data</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?= site_url('Report') ?>">Sales</a>
                    </li>
                    <li class="breadcrumb-item active">Reports</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<section class="content">
    <?php $this->view('message') ?>
    <div class="container-fluid">
        <div class="col-12">
            <div class="card">


                <div class="card-header">
                    <button id="export" data-target="#modal-export" data-toggle="modal" class="btn btn-warning">
                        <i class="fas fa-download"></i> <b>Export Report</b>
                    </button>
                    <button id="export_detail" data-target="#modal-export-detail" data-toggle="modal" class="btn btn-warning">
                        <i class="fas fa-download"></i> <b>Export Detail</b>
                    </button>
                </div>



                <!-- /.card-header -->
                <div class="card-body">
                    <table id="example2" class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Invoice</th>
                                <th>Date</th>
                                <th>Customer</th>
                                <th>Sub Total</th>
                                <th>Discount</th>
                                <th>Payment Method</th>
                                <th>Grand Total</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1;
                            foreach ($row->result() as $key => $data) { ?>
                                <tr>
                                    <td><?= $no++ ?> </td>
                                    <td><?= $data->invoice ?> </td>
                                    <td><?= indo_date($data->date) ?> </td>
                                    <td><?= $data->customer_name ?> </td>
                                    <td class="text-right"><?= indo_currency($data->total_price) ?> </td>
                                    <td class="text-right"><?= indo_currency($data->discount) ?> </td>
                                    <td><?= $data->method ?></td>
                                    <td class="text-right"><?= indo_currency($data->final_price) ?> </td>
                                    <td class="text-center" width="250px">
                                        <button id="detail" data-target="#modal-detail" data-toggle="modal" class="btn btn-default btn-xs" data-invoice="<?= $data->invoice ?>" data-date="<?= indo_date($data->date) ?>" data-time="<?= substr($data->sale_created, 11, 5)  ?>" data-customer="<?= $data->customer_name ?>" data-total="<?= indo_currency($data->total_price) ?>" data-discount="<?= indo_currency($data->discount) ?>" data-grandtotal="<?= indo_currency($data->final_price) ?>" data-cash="<?= indo_currency($data->cash) ?>" data-remaining="<?= indo_currency($data->remaining) ?>" data-note="<?= $data->note ?>" data-method="<?= ucfirst($data->method) ?>" data-cashier="<?= $data->karyawan_name ?>" data-saleid="<?= $data->sale_id ?>"> <i class="fa fa-eye"></i><b> Details</b></button>
                                        <a href="<?= site_url('Transaction/Sales/cetak/' . $data->sale_id) ?>" target="_blank" class="btn btn-primary btn-xs">
                                            <i class=" fa fa-edit"></i> <b>Print</b>
                                        </a>
                                        <?php if ($this->fungsi->user_login()->level == 1) {  ?>

                                            <a href="<?= site_url('Transaction/Sales/del/' . $data->sale_id) ?>" class="btn btn-danger btn-xs" onclick="return confirm('Apakah anda yakin?')">
                                                <i class="fa fa-trash"></i> <b>Delete</b>
                                            </a>

                                        <?php } ?>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->



<div class="modal fade" id="modal-detail">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Details</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table">
                    <tr>
                        <th style="width: 15%;"> Invoice</th>
                        <td style="width: 25%;"><span id="invoice"></span></td>

                    </tr>
                    <tr>
                        <th>Date Time</th>
                        <td><span id="datetime"></span></td>
                        <th>Payment Methode</th>
                        <td><span id="method"></span></td>
                    </tr>
                    <tr>

                        <th>Cashier</th>
                        <td><span id="cashier"></span></td>
                        <th style="width: 20%;">Customer</th>
                        <td style="width: 25%;"><span id="customer"></span></td>
                    </tr>
                    <tr>
                        <th>Total</th>
                        <td><span id="total"></span></td>
                        <th>Cash</th>
                        <td><span id="cash"></span></td>
                    </tr>
                    <tr>
                        <th>Discount</th>
                        <td><span id="discount"></span></td>
                        <th>Change</th>
                        <td><span id="change"></span></td>
                    </tr>
                    <tr>
                        <th>Grand Total</th>
                        <td><span id="grandtotal"></span></td>
                        <th>Note</th>
                        <td><span id="note"></span></td>
                    </tr>
                    <tr>
                        <th style="width: 100px;">Product</th>
                        <td colspan="4"> <span id="product_data"></span></td>
                    </tr>
                </table>
            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-- MODAL EXPORT BY DATE -->
<div class="modal fade" id="modal-export">
    <div class="modal-dialog modal-sm">
        <div class="modal-content bg-warning">
            <div class="modal-header">
                <h4 class="modal-title">Export Report Data</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
            </div>
            <form action="<?= site_url('Report/export_service') ?>" method="get" target="_blank">
                <div class="modal-body">
                    <div class="col-md-12">
                        <div class="form-group ">
                            <label>From *</label>
                            <input type="date" class="form-control" name="tgl1" required>
                        </div>
                        <div class="form-group ">
                            <label>To *</label>
                            <input type="date" class="form-control" name="tgl2" required>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" value="cetak" name="cetak" class="btn btn-outline-dark">Export</button>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->


<!-- MODAL EXPORT DETAIL DATE -->
<div class="modal fade" id="modal-export-detail">
    <div class="modal-dialog modal-sm">
        <div class="modal-content bg-warning">
            <div class="modal-header">
                <h4 class="modal-title">Export Detail Report</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
            </div>
            <form action="<?= site_url('Report/export_detail_service') ?>" method="get" target="_blank">
                <div class="modal-body">
                    <div class="col-md-12">
                        <div class="form-group ">
                            <label>From *</label>
                            <input type="date" class="form-control" name="tglservice1" required>
                        </div>
                        <div class="form-group ">
                            <label>To *</label>
                            <input type="date" class="form-control" name="tglservice2" required>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" value="printexcel" name="printexcel" class="btn btn-outline-dark">Export</button>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->