<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Kas_m extends CI_Model
{

    public function get($id = null)
    {
        $this->db->from('p_kas');
        if ($id != null) {
            $this->db->where('kas_id', $id);
        }
        $query = $this->db->get();
        return $query;
    }
    public function del($id)
    {
        $this->db->where('kas_id', $id);
        $this->db->delete('p_kas');
    }

    public function get_karyawan()
    {
        $this->db->from('karyawan');
        $this->db->order_by('karyaawan_id', 'desc');
        $query = $this->db->get();
        return $query;
    }

    // INDEX PINJAM
    public function get_keluar()
    {
        $this->db->select('p_kas.kas_id,  karyawan.name as karyawan_name, p_kas.total as total, type, date, keterangan, karyawan.karyawan_id');
        $this->db->from('p_kas');
        $this->db->join('karyawan', 'p_kas.karyawan_id = karyawan.karyawan_id');
        $this->db->where('type', 'keluar');
        $this->db->order_by('kas_id', 'desc');
        $query = $this->db->get();
        return $query;
    }

    // TAMBAH PINJAM
    public function add_keluar($post)
    {
        $params = [
            'karyawan_id' => $post['karyawan_id'],
            'total' => $post['total'],
            'type' => 'keluar',
            'keterangan' => $post['keterangan'],
            'date' => $post['date'],
        ];
        $this->db->insert('p_kas', $params);
    }

    // INDEX masuk
    public function get_masuk()
    {
        $this->db->select('p_kas.kas_id,  karyawan.name as karyawan_name, p_kas.total as total, type, date, keterangan, karyawan.karyawan_id');
        $this->db->from('p_kas');
        $this->db->join('karyawan', 'p_kas.karyawan_id = karyawan.karyawan_id');
        $this->db->where('type', 'masuk');
        $this->db->order_by('kas_id', 'desc');
        $query = $this->db->get();
        return $query;
    }

    // TAMBAH masuk
    public function add_masuk($post)
    {
        $params = [
            'karyawan_id' => $post['karyawan_id'],
            'total' => $post['total'],
            'type' => 'masuk',
            'keterangan' => $post['keterangan'],
            'date' => $post['date'],
        ];
        $this->db->insert('p_kas', $params);
    }
    
    public function view_kas($tgl1, $tgl2)
    {
        $this->db->select('*, karyawan.name as karyawan_name');
        $this->db->from('p_kas');
        $this->db->join('karyawan', 'p_kas.karyawan_id = karyawan.karyawan_id', 'left');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        $query = $this->db->get()->result();
        return $query;
    }
}
