<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Keluhan_m extends CI_Model
{

    public function get($id = null)
    {
        $this->db->from('p_keluhancustomer');
        if ($id != null) {
            $this->db->where('keluhan_id', $id);
        }
        $query = $this->db->get();
        return $query;
    }

    // DELETE KELUHAN
    public function del($id)
    {
        $this->db->where('keluhan_id', $id);
        $this->db->delete('p_keluhancustomer');
    }

    // INDEX KELUHAN
    public function get_keluhan($id = null)
    {
        $this->db->select('p_keluhancustomer.keluhan_id, karyawan.name as karyawan_name, customer.name as customer_name, keluhan, solusi, date, karyawan.karyawan_id');
        $this->db->from('p_keluhancustomer');
        $this->db->join('karyawan', 'p_keluhancustomer.karyawan_id = karyawan.karyawan_id');
        $this->db->join('customer', 'p_keluhancustomer.customer_id = customer.customer_id');
        $query = $this->db->get();
        return $query;
    }

    // TAMBAH KELUHAN
    public function add_keluhan($post)
    {
        $params = [
            'karyawan_id' => $post['karyawan_id'],
            'customer_id' => $post['customer_id'],
            'keluhan' => $post['keluhan'],
            'solusi' => $post['solusi'],
            'date' => $post['date'],
        ];
        $this->db->insert('p_keluhancustomer', $params);
    }
}
