<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Keluhan extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
       	check_not_login_smd();
        $this->load->model(['Karyawan_m', 'Rpotkaryawan/Keluhan_m', 'Customer/Customer_m']);
    }

    // INDEX PINJAM
    public function index()
    {
        $data['row'] = $this->Keluhan_m->get_keluhan()->result();
        $this->template->load('template', 'RpotKaryawan/Keluhan/keluhancustomer_data', $data);
        $this->load->view('datatables');
    }

    // SELECT KARYAWAN/CUSTOMER KELUHAN FORM
    public function keluhan_add()
    {
        $karyawan = $this->Karyawan_m->get_terapis()->result();
        $customer = $this->Customer_m->get()->result();
        $data = [
            'karyawan' => $karyawan,
            'customer' => $customer,
        ];
        $this->template->load('template', 'RpotKaryawan/Keluhan/keluhancustomer_form', $data);
        $this->load->view('datatables');
    }

    // FORM PROSES
    public function process()
    {
        if (isset($_POST['keluhan_add'])) {
            $post = $this->input->post(null, TRUE);
            $this->Keluhan_m->add_keluhan($post);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Data berhasil disimpan');
            }
            redirect('Rpotkaryawan/Keluhan');
        }
    }

    public function del($id)
    {
        $this->Keluhan_m->del($id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil Dihapus');
        }
        redirect('Rpotkaryawan/Keluhan');
    }
}
