<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?= site_url('User') ?>">User</a></li>
                    <li class="breadcrumb-item active">Data User</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<section class="content">
    <div class="container-fluid">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <span class="float-left">
                        <h2>Data Users</h2>
                    </span>
                    <a href="<?= site_url('User/add') ?>" class="btn btn-primary float-right">
                        <i class="fa fa-user-plus"></i> <b>Create</b>
                    </a>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <table id="example2" class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Username</th>
                                <th>Level</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1;
                            foreach ($row->result() as $key => $data) { ?>
                                <tr>
                                    <td><?= $no++ ?> </td>
                                    <td><?= $data->name ?> </td>
                                    <td><?= $data->username ?> </td>
                                    <td><?= $data->level == 1 ? "Admin" : "Kasir" ?> </td>
                                    <td class="text-center" width="150px">
                                        <form action="<?= site_url('User/del/' . $data->user_id) ?>" method="post">
                                            <a href="<?= site_url('User/edit/' . $data->user_id) ?>" class="btn btn-primary btn-xs">
                                                <i class="fa fa-edit"></i> <b>Update</b>
                                            </a>
                                            <input type="hidden" name="user_id" value="<?= $data->user_id ?>">
                                            <button onclick="return confirm('Apakah anda yakin?')" class="btn btn-danger btn-xs">
                                                <i class="fa fa-trash">
                                                </i> <b>Delete</b>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->