<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Kas Keluar</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">Transaction</li>
                    <li class="breadcrumb-item active">Data Kas Keluar</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<section class="content">
    <?php $this->view('message') ?>
    <div class="container-fluid">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <a href="<?= site_url('Transaction/Kas/masuk') ?>" class="btn btn-primary">
                        <b>Data Kas Masuk</b>
                    </a>
                    <button id="export_detail" data-target="#modal-export-in-out" data-toggle="modal" class="btn btn-warning">
                        <i class="fas fa-download"></i> <b>Report</b>
                    </button>
                    <a href="<?= site_url('Transaction/Kas/keluar_add') ?>" class="btn btn-primary float-right">
                        <i class="fas fa-plus-circle"></i> <b>Kas Keluar</b>
                    </a>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <table id="example2" class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th style="width:10%;">Date</th>
                                <th style="width:15%;">Karyawan</th>
                                <th style="width:20%;">Total</th>
                                <th>Type</th>
                                <th>Keterangan</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1;
                            foreach ($row as $key => $data) { ?>
                                <tr>
                                    <td style="width:5%"><?= $no++ ?> </td>
                                    <td class="text-left"><?= indo_date($data->date) ?> </td>
                                    <td><?= $data->karyawan_name ?> </td>
                                    <td><?= indo_currency($data->total) ?> </td>
                                    <td class="text-left"><?= ucfirst($data->type) ?> </td>
                                    <td class="text-left"><?= $data->keterangan ?> </td>
                                    <td class="text-center" width="160px">
                                        <a href="<?= site_url('Transaction/Kas/keluar_del/' . $data->kas_id) ?>" onclick="return confirm('Yakin hapus data?')" class="btn btn-danger btn-xs">
                                            <i class="fa fa-trash"></i> Delete
                                        </a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->


<!-- MODAL EXPORT DETAIL DATE -->
<div class="modal fade" id="modal-export-in-out">
    <div class="modal-dialog modal-sm">
        <div class="modal-content bg-warning">
            <div class="modal-header">
                <h4 class="modal-title">Export Report</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
            </div>
            <form action="<?= site_url('Transaction/Kas/export_excel') ?>" method="get" target="_blank">
                <div class="modal-body">
                    <div class="col-md-12">
                        <div class="form-group ">
                            <label>From *</label>
                            <input type="date" class="form-control" name="tgl1" required>
                        </div>
                        <div class="form-group ">
                            <label>To *</label>
                            <input type="date" class="form-control" name="tgl2" required>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" value="printexcel" name="printexcel" class="btn btn-outline-dark">Export</button>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->