<?php defined('BASEPATH') or exit('No direct script access allowed');

class Sales_m extends CI_Model
{
    // INVOICE SERVICE
    public function invoice_no()
    {
        $sql = "SELECT MAX(MID(invoice,9,4)) AS invoice_no 
            FROM t_sale 
            WHERE MID(invoice,3,6) = DATE_FORMAT(CURDATE(), '%y%m%d')";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $n = ((int)$row->invoice_no) + 1;
            $no = sprintf("%'.04d", $n);
        } else {
            $no = "0001";
        }
        $invoice = "MP" . date('ymd') . $no;
        return $invoice;
    }

    // GET REPORT DATA SERVICE
    public function get_sale($id = null)
    {
        $this->db->select('*, customer.name as customer_name, karyawan.name as karyawan_name, users.name as user_name, t_sale.created as sale_created');
        $this->db->from('t_sale');
        $this->db->join('customer', 't_sale.customer_id = customer.customer_id', 'left');
        $this->db->join('karyawan', 't_sale.cashier_id = karyawan.karyawan_id');

        $this->db->join('users', 't_sale.user_id = users.user_id');
        if ($id != null) {
            $this->db->where('sale_id', $id);
        }
        $this->db->order_by('date', 'desc');
        $query = $this->db->get();
        return $query;
    }
    // GET REPORT DETAIL SERVICE
    public function get_sale_detail($sale_id = null)
    {
        $this->db->select('*, karyawan.name as karyawan_name');
        $this->db->from('t_sale_detail');
        $this->db->join('p_bahan', 't_sale_detail.bahan_id = p_bahan.bahan_id', 'left');
        $this->db->join('p_services', 't_sale_detail.services_id = p_services.services_id', 'left');
        $this->db->join('karyawan', 't_sale_detail.terapis_id = karyawan.karyawan_id', 'left');
        if ($sale_id != null) {
            $this->db->where('t_sale_detail.sale_id', $sale_id);
        }
        $query = $this->db->get();
        return $query;
    }
    // DELETE REPORT SERVICE
    public function del_sale($id)
    {
        $this->db->where('sale_id', $id);
        $this->db->delete('t_sale');
    }

    // START SALESM FORM SALE
    // GET CART SERVICE
    public function get_cart($params = null)
    {
        $this->db->select('*, p_bahan.bahan_name as bahan_name, p_services.services_name as services_name, t_cart.cart_price as cart_price, t_cart.commision as commision');
        $this->db->from('t_cart');
        $this->db->join('p_bahan', 't_cart.bahan_id = p_bahan.bahan_id', 'left');
        $this->db->join('p_services', 't_cart.services_id = p_services.services_id', 'left');
        if ($params != null) {
            $this->db->where($params);
        }
        $this->db->where('user_id', $this->session->userdata('user_id'));
        $query = $this->db->get();
        return $query;
    }
    // ADD CART BAHAN
    public function add_cart_bahan($post)
    {
        $query = $this->db->query("SELECT MAX(cart_id) AS cart_no FROM t_cart");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $car_no = ((int)$row->cart_no) + 1;
        } else {
            $car_no = "1";
        }

        $params = array(
            'cart_id' => $car_no,
            'bahan_id' => $post['bahan_id'],
            'cart_price' => '0',
            'commision' => '0',
            'hpp' => '0',
            'discount_item' => '0',
            'qty' => $post['qty_bahan'],
            'disc_total' => '0',
            'sub_total' => '0',
            'total' => '0',
            'user_id' => $this->session->userdata('user_id')

            
        );
        $this->db->insert('t_cart', $params);
    }
    
    // ADD CART SERVICE
    public function add_cart_services($post)
    {
        $query = $this->db->query("SELECT MAX(cart_id) AS cart_no FROM t_cart");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $car_no = ((int)$row->cart_no) + 1;
        } else {
            $car_no = "1";
        }

        $params = array(
            'cart_id' => $car_no,
            'services_id' => $post['services_id'],
            'terapis_id' => $post['terapis_id'],
            'cart_price' => $post['services_price'],
            'commision' => $post['commision'] * $post['qty'],
            'hpp' => ($post['modal']  * $post['qty']),
            'discount_item' => $post['disc_item'],
            'qty' => $post['qty'],
            'disc_total' => ($post['services_price'] * $post['disc_item'] / 100),
            'sub_total' => ($post['services_price']  * $post['qty']),
            'total' => (($post['services_price'] - ($post['services_price'] * $post['disc_item'] / 100))  * $post['qty']),
            'user_id' => $this->session->userdata('user_id')

        );
        $this->db->insert('t_cart', $params);
    }
    // DEL CART SERVICE
    public function del_cart($params = null)
    {
        if ($params != null) {
            $this->db->where($params);
        }
        $this->db->delete('t_cart');
    }
    // EDIT CART SERVICE
    public function edit_cart($post)
    {
        $params = array(
            'cart_price' => $post['price_cart'],
            'qty' => $post['qty'],
            'discount_item' => $post['discount'],
            'sub_total' => ($post['price_cart'] * $post['qty']),
            'disc_total' => (($post['price_cart'] * $post['discount'] / 100) * $post['qty']),
            'total' => $post['total'],
        );
        $this->db->where('cart_id', $post['cart_id']);
        $this->db->update('t_cart', $params);
    }
    // PROSES ADD SERVICE
    public function add_sale($post)
    {
        $params = array(
            'invoice' => $this->invoice_no(),
            'cashier_id' => $post['cashier_id'],
            'customer_id' => $post['customer_id'],
            'total_price' => $post['subtotal'],
            'discount' => $post['discount'],
            'final_price' => $post['grandtotal'],
            'cash' => $post['cash'],
            'remaining' => $post['change'],
            'note' => $post['note'],
            'point' => $post['point'],
            'hpp' => $post['tothpp'],
            'method' => $post['method_payment'],
            'date' => $post['date'],
            'user_id' => $this->session->userdata('user_id')
        );
        $this->db->insert('t_sale', $params);
        return $this->db->insert_id();
    }
    // PROSES ADD SALE SERVICE DETAIL
    function add_sale_detail($params)
    {
        $this->db->insert_batch('t_sale_detail', $params);
    }

    // PROSES ADD PRODUCT
    public function add_sale_item($post)
    {
        $params = array(
            'invoice' => $this->invoice_no_item(),
            'customer_id' => $post['customer_id'],
            'cashier_id' => $post['cashier_id'],
            'total_price' => $post['subtotal'],
            'discount' => $post['discount'],
            'final_price' => $post['grandtotal'],
            'cash' => $post['cash'],
            'remaining' => $post['change'],
            'point' => $post['point'],
            'method' => $post['method_payment'],
            'note' => $post['note'],
            'date' => $post['date'],
            'user_id' => $this->session->userdata('user_id')
        );
        $this->db->insert('t_sale_item', $params);
        return $this->db->insert_id();
    }
    // PROSES ADD SALE PRODUCT DETAIL
    function add_sale_detail_item($params)
    {
        $this->db->insert_batch('t_sale_detail_item', $params);
    }
    // GET DATA PRODUCT
    public function get_sale_item($id = null)
    {
        $this->db->select('*, customer.name as customer_name, karyawan.name as karyawan_name,  users.name as user_name, t_sale_item.created as sale_created');
        $this->db->from('t_sale_item');
        $this->db->join('customer', 't_sale_item.customer_id = customer.customer_id', 'left');
        $this->db->join('karyawan', 't_sale_item.cashier_id = karyawan.karyawan_id');
        $this->db->join('users', 't_sale_item.user_id = users.user_id');
        if ($id != null) {
            $this->db->where('sale_id', $id);
        }
        $this->db->order_by('date', 'desc');
        $query = $this->db->get();
        return $query;
    }
    // GET DETAIL PRODUCT
    public function get_sale_detail_item($sale_id = null)
    {
        $this->db->from('t_sale_detail_item');
        $this->db->join('p_item', 't_sale_detail_item.item_id = p_item.item_id', 'left');
        if ($sale_id != null) {
            $this->db->where('t_sale_detail_item.sale_id', $sale_id);
        }
        $query = $this->db->get();
        return $query;
    }
    // DELETE REPORT PRODUCT
    public function del_sale_item($id)
    {
        $this->db->where('sale_id', $id);
        $this->db->delete('t_sale_item');
    }

    // SALES FORM PRODUCT
    // INVOICE ITEM
    public function invoice_no_item()
    {
        $sql = "SELECT MAX(MID(invoice,9,4)) AS invoice_no 
            FROM t_sale_item 
            WHERE MID(invoice,3,6) = DATE_FORMAT(CURDATE(), '%y%m%d')";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $n = ((int)$row->invoice_no) + 1;
            $no = sprintf("%'.04d", $n);
        } else {
            $no = "0001";
        }
        $invoice = "IP" . date('ymd') . $no;
        return $invoice;
    }
    // GET DATA FROM DATABASE 
    public function get_cart_product($params = null)
    {
        $this->db->select('*, p_item.item_name as item_name, t_cart_item.cart_price as cart_price');
        $this->db->from('t_cart_item');
        $this->db->join('p_item', 't_cart_item.item_id = p_item.item_id', 'left');
        if ($params != null) {
            $this->db->where($params);
        }
        $this->db->where('user_id', $this->session->userdata('user_id'));
        $query = $this->db->get();
        return $query;
    }
    // DEL CART 
    public function del_cart_product($params = null)
    {
        if ($params != null) {
            $this->db->where($params);
        }
        $this->db->delete('t_cart_item');
    }
    // ADD CART PRODUCT
    public function add_cart_product($post)
    {
        $query = $this->db->query("SELECT MAX(cart_id) AS cart_no FROM t_cart_item");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $car_no = ((int)$row->cart_no) + 1;
        } else {
            $car_no = "1";
        }
        $params = array(
            'cart_id' => $car_no,
            'item_id' => $post['item_id'],
            'cart_price' => $post['item_price'],
            'discount_item' => $post['disc_item'],
            'qty' => $post['qty'],
            'sub_total' => ($post['item_price']  * $post['qty']),
            'disc_total' => ($post['item_price'] * $post['disc_item'] / 100),
            'total' => (($post['item_price'] - ($post['item_price'] * $post['disc_item'] / 100))  * $post['qty']),
            'user_id' => $this->session->userdata('user_id')
        );
        $this->db->insert('t_cart_item', $params);
    }
    // EDIT CART PRODUCT
    public function edit_cart_product($post)
    {
        $params = array(
            'cart_price' => $post['price_cart'],
            'qty' => $post['qty'],
            'discount_item' => $post['discount'],
            'sub_total' => ($post['price_cart'] * $post['qty']),
            'disc_total' => (($post['price_cart'] * $post['discount'] / 100) * $post['qty']),
            'total' => $post['total'],
        );
        $this->db->where('cart_id', $post['cart_id']);
        $this->db->update('t_cart_item', $params);
    }
    // END SALES FORM PRODUCT

    // DELETE REPORT SERVICE
    public function del_refund($id)
    {
        $this->db->where('sale_id', $id);
        $this->db->delete('t_refund');
    }

    public function get_refund($id = null)
    {
        $this->db->select('*, customer.name as customer_name, karyawan.name as karyawan_name, users.name as user_name, t_refund.created as refund_created');
        $this->db->from('t_refund');
        $this->db->join('customer', 't_refund.customer_id = customer.customer_id', 'left');
        $this->db->join('karyawan', 't_refund.cashier_id = karyawan.karyawan_id', 'left');
        $this->db->join('users', 't_refund.user_id = users.user_id');
        if ($id != null) {
            $this->db->where('sale_id', $id);
        }
        $this->db->order_by('date', 'desc');
        $query = $this->db->get();
        return $query;
    }

    public function get_refund_detail($sale_id = null)
    {
        $this->db->from('t_refund_detail');
        $this->db->join('p_item', 't_refund_detail.item_id = p_item.item_id', 'left');
        if ($sale_id != null) {
            $this->db->where('t_refund_detail.sale_id', $sale_id);
        }
        $query = $this->db->get();
        return $query;
    }

    public function move_refund_detail($sale_id = null)
    {
        $this->db->from('t_sale_detail_item');
        if ($sale_id != null) {
            $this->db->where('t_sale_detail_item.sale_id', $sale_id);
        }
        $q = $this->db->get()->result();
        foreach ($q as $r) { // loop over results
            $this->db->insert('t_refund_detail', $r); // insert each row to another table
        }
    }

    public function move_refund($id = null)
    {
        $this->db->from('t_sale_item');
        if ($id != null) {
            $this->db->where('sale_id', $id);
        }
        $q = $this->db->get()->result();
        foreach ($q as $r) { // loop over results
            $this->db->insert('t_refund', $r); // insert each row to another table
        }
    }

    public function view_product($tgl1, $tgl2)
    {
        $this->db->select('*, customer.name as customer_name, t_sale_item.point, t_sale_item.total_price, t_sale_item.discount, t_sale_item.method, t_sale_item.remaining, karyawan.name as karyawan_name,  users.name as user_name');
        $this->db->from('t_sale_item');
        $this->db->join('customer', 't_sale_item.customer_id = customer.customer_id', 'left');
        $this->db->join('karyawan', 't_sale_item.cashier_id = karyawan.karyawan_id');
        $this->db->join('users', 't_sale_item.user_id = users.user_id');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->result(); // Tampilkan data transaksi sesuai tanggal yang diinput oleh user pada filter  
    }

    public function view_product_detail($tgl_dtl1, $tgl_dtl2)
    {
        $this->db->select('*, t_sale_detail_item.date');
        $this->db->from('t_sale_detail_item');
        $this->db->join('p_item', 't_sale_detail_item.item_id = p_item.item_id');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl_dtl1)) . '" and "' . date('Y-m-d', strtotime($tgl_dtl2)) . '"');
        return $this->db->get()->result(); // Tampilkan data transaksi sesuai tanggal yang diinput oleh user pada filter  

    }

    public function view_service($tgl1, $tgl2)
    {
        $this->db->select('*, customer.name as customer_name, t_sale.point, t_sale.total_price, t_sale.discount, t_sale.method, t_sale.remaining, karyawan.name as karyawan_name');
        $this->db->from('t_sale');
        $this->db->join('customer', 't_sale.customer_id = customer.customer_id');
        $this->db->join('karyawan', 't_sale.cashier_id = karyawan.karyawan_id');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->result(); // Tampilkan data transaksi sesuai tanggal yang diinput oleh user pada filter  
    }

    public function view_detail_service($tglservice1, $tglservice2)
    {
        $this->db->select('*, kry.name as kry_name, t_sale_detail.commision as commision');
        $this->db->from('t_sale_detail');
        $this->db->join('p_services', 't_sale_detail.services_id = p_services.services_id', 'left');
        $this->db->join('p_bahan', 't_sale_detail.bahan_id = p_bahan.bahan_id', 'left');
        $this->db->join('karyawan as kry', 't_sale_detail.terapis_id = kry.karyawan_id', 'left');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tglservice1)) . '" and "' . date('Y-m-d', strtotime($tglservice2)) . '"');
        $query = $this->db->get();
        return $query->result();
    }

    public function view_refund($tgl1, $tgl2)
    {
        $this->db->select('*, customer.name as customer_name, t_refund.point, t_refund.total_price, t_refund.discount, t_refund.method, t_refund.remaining, karyawan.name as karyawan_name, users.name as user_name, t_refund.date as refund_date');
        $this->db->from('t_refund');
        $this->db->join('customer', 't_refund.customer_id = customer.customer_id', 'left');
        $this->db->join('karyawan', 't_refund.cashier_id = karyawan.karyawan_id', 'left');
        $this->db->join('users', 't_refund.user_id = users.user_id');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->result(); // Tampilkan data transaksi sesuai tanggal yang diinput oleh user pada filter  
    }

    public function view_detail_refund($tgl1, $tgl2)
    {
        $this->db->from('t_refund_detail');
        $this->db->join('p_item', 't_refund_detail.item_id = p_item.item_id', 'left');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        $query = $this->db->get()->result();
        return $query;
    }
}
