<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Item_m extends CI_Model
{

    // menampilkan data item
    public function get($id = null)
    {
        $this->db->from('p_item');
        if ($id != null) {
            $this->db->where('item_id', $id);
        }
        $query = $this->db->get();
        return $query;
    }


    // menghapus data item
    public function del($id)
    {

        $this->db->where('item_id', $id);
        $this->db->delete('p_item');
    }

    // menambah data item
    public function add($post)
    {
        $params = [
            'item_name' => $post['item_name'],
            'item_price' => $post['item_price'],
        ];
        $this->db->insert('p_item', $params);
    }


    // mengedit data item
    public function edit($post)
    {
        $params = [
            'item_name' => $post['item_name'],
            'item_price' => $post['item_price'],
            'updated' => date('Y-m-d H:i:s')
        ];
        $this->db->where('item_id', $post['id']);
        $this->db->update('p_item', $params);
    }

    // update stock
    function update_stock_in($data)
    {
        $qty = $data['qty'];
        $id = $data['item_id'];
        $sql = "UPDATE p_item SET stock = stock + '$qty' WHERE item_id = '$id'";
        $this->db->query($sql);
    }

    function update_stock_out($data)
    {
        $qty = $data['qty'];
        $id = $data['item_id'];
        $sql = "UPDATE p_item SET stock = stock - '$qty' WHERE item_id = '$id'";
        $this->db->query($sql);
    }

    public function view_stock()
    {
        $this->db->select('*');
        $this->db->from('p_item');
        return $this->db->get()->result(); // Tampilkan data transaksi sesuai tanggal yang diinput oleh user pada filter  
    }
    
    public function view_stock_in_out($tgl1, $tgl2)
    {
        $this->db->from('t_stock');
        $this->db->join('p_item', 't_stock.item_id = p_item.item_id', 'left');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        $query = $this->db->get()->result();
        return $query;
    }
}
