<?php defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard_m extends CI_Model
{

    // COUNT NUMROWS
    function num_customer()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('customer_id');
        $this->db->distinct();
        $this->db->from('customer');
        $this->db->where('DATE(created)', $curr_date); //use date function
        $query = $this->db->get();
        return $query->num_rows();
    }

    function num_product()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('sale_id');
        $this->db->distinct();
        $this->db->from('t_sale_item');
        $this->db->where('DATE(date)', $curr_date); //use date function
        $query = $this->db->get();
        return $query->num_rows();
    }

    function num_treatment()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('sale_id');
        $this->db->distinct();
        $this->db->from('t_sale');
        $this->db->where('DATE(date)', $curr_date); //use date function
        $query = $this->db->get();
        return $query->num_rows();
    }

    function num_customer_filter($tgl1, $tgl2)
    {
        $this->db->select('customer_id');
        $this->db->distinct();
        $this->db->from('customer');
       $this->db->where('created BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        $query = $this->db->get();
        return $query->num_rows();
    }

    function num_product_filter($tgl1, $tgl2)
    {
        $this->db->select('sale_id');
        $this->db->distinct();
        $this->db->from('t_sale_item');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        $query = $this->db->get();
        return $query->num_rows();
    }

    function num_treatment_filter($tgl1, $tgl2)
    {
        $this->db->select('sale_id');
        $this->db->distinct();
        $this->db->from('t_sale');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        $query = $this->db->get();
        return $query->num_rows();
    }
    // END NUMROWS

    // FINAL PRICE 
    function final_treatment()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale');
        $this->db->where('DATE(date)', $curr_date); //use date function

        return $this->db->get()->row()->total;
    }

    function final_product()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale_item');
        $this->db->where('DATE(date)', $curr_date); //use date function

        return $this->db->get()->row()->total;
    }

    function final_treatment_filter($tgl1, $tgl2)
    {
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->row()->total;
    }

    function final_product_filter($tgl1, $tgl2)
    {
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale_item');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->row()->total;
    }
    // END FINAL PRICE

    // HPP SERVICES
    function count_tot_hpp()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(hpp) as total');
        $this->db->from('t_sale');
        $this->db->where('DATE(date)', $curr_date); //use date function

        return $this->db->get()->row()->total;
    }
    
    function count_tot_hpp_filter($tgl1, $tgl2)
    {
        $this->db->select('SUM(hpp) as total');
        $this->db->from('t_sale');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->row()->total;
    }
    // END HPP

    // SUB PRICE
    function sub_treatment()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(total_price) as total');
        $this->db->from('t_sale');
        $this->db->where('DATE(date)', $curr_date); //use date function

        return $this->db->get()->row()->total;
    }

    function sub_product()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(total_price) as total');
        $this->db->from('t_sale_item');
        $this->db->where('DATE(date)', $curr_date); //use date function

        return $this->db->get()->row()->total;
    }

    function sub_product_filter($tgl1, $tgl2)
    {
        $this->db->select('SUM(total_price) as total');
        $this->db->from('t_sale_item');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->row()->total;
    }

    function sub_treatment_filter($tgl1, $tgl2)
    {
        $this->db->select('SUM(total_price) as total');
        $this->db->from('t_sale');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->row()->total;
    }

    // END SUB PRICE




    // SUB EDC
    function sub_product_bni_filter($tgl1, $tgl2)
    {
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale_item');
        $this->db->where('method', 'BNI');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->row()->total;
    }

    function sub_treatment_bni_filter($tgl1, $tgl2)
    {
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale');
        $this->db->where('method', 'BNI');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->row()->total;
    }

    function sub_product_bni()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale_item');
        $this->db->where('method', 'BNI');
        $this->db->where('DATE(date)', $curr_date); //use date function

        return $this->db->get()->row()->total;
    }

    function sub_treatment_bni()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale');
        $this->db->where('method', 'BNI');
        $this->db->where('DATE(date)', $curr_date); //use date function

        return $this->db->get()->row()->total;
    }
    function sub_product_bca_filter($tgl1, $tgl2)
    {
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale_item');
        $this->db->where('method', 'BCA');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->row()->total;
    }

    function sub_treatment_bca_filter($tgl1, $tgl2)
    {
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale');
        $this->db->where('method', 'BCA');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->row()->total;
    }

    function sub_product_bca()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale_item');
        $this->db->where('method', 'BCA');
        $this->db->where('DATE(date)', $curr_date); //use date function

        return $this->db->get()->row()->total;
    }

    function sub_treatment_bca()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale');
        $this->db->where('method', 'BCA');
        $this->db->where('DATE(date)', $curr_date); //use date function

        return $this->db->get()->row()->total;
    }
    function sub_product_mandiri_filter($tgl1, $tgl2)
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale_item');
        $this->db->where('method', 'Mandiri');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->row()->total;
    }

    function sub_treatment_mandiri_filter($tgl1, $tgl2)
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale');
        $this->db->where('method', 'Mandiri');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->row()->total;
    }

    function sub_product_mandiri()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale_item');
        $this->db->where('method', 'Mandiri');
        $this->db->where('DATE(date)', $curr_date); //use date function

        return $this->db->get()->row()->total;
    }

    function sub_treatment_mandiri()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale');
        $this->db->where('method', 'Mandiri');
        $this->db->where('DATE(date)', $curr_date); //use date function

        return $this->db->get()->row()->total;
    }

    function sub_product_cash_filter($tgl1, $tgl2)
    {
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale_item');
        $this->db->where('method', 'Cash');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->row()->total;
    }

    function sub_treatment_cash_filter($tgl1, $tgl2)
    {
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale');
        $this->db->where('method', 'Cash');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->row()->total;
    }

    function sub_product_cash()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale_item');
        $this->db->where('method', 'Cash');
        $this->db->where('DATE(date)', $curr_date); //use date function

        return $this->db->get()->row()->total;
    }

    function sub_treatment_cash()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(final_price) as total');
        $this->db->from('t_sale');
        $this->db->where('method', 'Cash');
        $this->db->where('DATE(date)', $curr_date); //use date function

        return $this->db->get()->row()->total;
    }
     // END SUB EDC
    
    // SUB KAS MASUK/KELUAR

    function sub_kas_masuk()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(total) as total');
        $this->db->from('p_kas');
        $this->db->where('type', 'masuk');
        $this->db->where('DATE(date)', $curr_date); //use date function
        return $this->db->get()->row()->total;
    }

    function sub_kas_keluar()
    {
        $date = new DateTime("now");
        $curr_date = $date->format('Y-m-d ');
        $this->db->select('SUM(total) as total');
        $this->db->from('p_kas');
        $this->db->where('type', 'keluar');
        $this->db->where('DATE(date)', $curr_date); //use date function
        return $this->db->get()->row()->total;
    }

    function sub_kas_masuk_filter($tgl1, $tgl2)
    {
        $this->db->select('SUM(total) as total');
        $this->db->from('p_kas');
        $this->db->where('type', 'masuk');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->row()->total;
    }

    function sub_kas_keluar_filter($tgl1, $tgl2)
    {
        $this->db->select('SUM(total) as total');
        $this->db->from('p_kas');
        $this->db->where('type', 'keluar');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        return $this->db->get()->row()->total;
    }
    
    // END SUB KAS


   

    // GRAFIK CART
    function product_laris()
    {
        $this->db->SELECT('*, t_sale_detail.services_id, p_services.services_name, SUM(t_sale_detail.qty) as sold');
        $this->db->FROM('t_sale_detail');
        $this->db->JOIN('t_sale', 't_sale_detail.sale_id = t_sale.sale_id ');
        $this->db->JOIN('p_services', 't_sale_detail.services_id = p_services.services_id ');
        $this->db->GROUP_BY('t_sale_detail.services_id');
        $this->db->ORDER_BY('sold', 'desc');
        $this->db->LIMIT('10');
        $query = $this->db->get();
        return $query->result();
    }

    function stock_product()
    {
        $this->db->SELECT('*');
        $this->db->FROM('p_bahan');
        $this->db->ORDER_BY('stock', 'asc');
        $this->db->WHERE('stock < 10');
        $this->db->LIMIT('10');
        $query = $this->db->get();
        return $query->result();
    }
    // END GRAFIK

}
