<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Bahan_m extends CI_Model
{

    // menampilkan data bahan
    public function get($id = null)
    {
        $this->db->from('p_bahan');
        if ($id != null) {
            $this->db->where('bahan_id', $id);
        }
        $query = $this->db->get();
        return $query;
    }


    // menghapus data bahan
    public function del($id)
    {

        $this->db->where('bahan_id', $id);
        $this->db->delete('p_bahan');
    }

    // menambah data bahan
    public function add($post)
    {
        $params = [
            'bahan_name' => $post['bahan_name'],
        ];
        $this->db->insert('p_bahan', $params);
    }


    // mengedit data bahan
    public function edit($post)
    {
        $params = [
            'bahan_name' => $post['bahan_name'],
            'updated' => date('Y-m-d H:i:s')
        ];
        $this->db->where('bahan_id', $post['id']);
        $this->db->update('p_bahan', $params);
    }

    // update stock
    function update_stock_in($data)
    {
        $qty = $data['qty'];
        $id = $data['bahan_id'];
        $sql = "UPDATE p_bahan SET stock = stock + '$qty' WHERE bahan_id = '$id'";
        $this->db->query($sql);
    }

    function update_stock_out($data)
    {
        $qty = $data['qty'];
        $id = $data['bahan_id'];
        $sql = "UPDATE p_bahan SET stock = stock - '$qty' WHERE bahan_id = '$id'";
        $this->db->query($sql);
    }

    public function view_stock()
    {
        $this->db->select('*');
        $this->db->from('p_bahan');
        return $this->db->get()->result(); // Tampilkan data transaksi sesuai tanggal yang diinput oleh user pada filter  
    }
    
   
    public function view_stock_in_out($tgl1, $tgl2)
    {
        $this->db->from('t_stock_bahan');
        $this->db->join('p_bahan', 't_stock_bahan.bahan_id = p_bahan.bahan_id', 'left');
        $this->db->where('date BETWEEN "' . date('Y-m-d', strtotime($tgl1)) . '" and "' . date('Y-m-d', strtotime($tgl2)) . '"');
        $query = $this->db->get()->result();
        return $query;
    }
}
