<?php
defined('BASEPATH') or exit('No direct script access allowed');

class User extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        check_not_login();
        check_admin();
        $this->load->model('User_m');
        $this->load->library('form_validation');
    }

    public function index()
    {
        $data['row'] = $this->User_m->get();
        $this->template->load('template', 'User/User_data', $data);
        $this->load->view('datatables');
    }
    // FORM TAMBAH
    public function add()
    {
        $this->form_validation->set_rules('fullname', 'Name', 'required');
        $this->form_validation->set_rules('username', 'Username', 'required|min_length[5]|is_unique[users.username]');
        $this->form_validation->set_rules('password', 'Password', 'required|min_length[5]');
        $this->form_validation->set_rules(
            'pass-conf',
            'Confirmation Password',
            'required|matches[password]',
            array('matches' => '%s tidak sesuai dengan password')
        );
        $this->form_validation->set_rules('level', 'level', 'required');
        $this->form_validation->set_message('required', '%s masih kosong, silahkan isi');
        $this->form_validation->set_message('min_length', '{field} minimal 5 karakter');
        $this->form_validation->set_message('is_unique', '{field} ini sudah dipakai, silahkan ganti');


        if ($this->form_validation->run() == FALSE) {
            $this->template->load('template', 'User/User_form_add');
        } else {
            $post = $this->input->post(null, TRUE);
            $this->User_m->add($post);
            if ($this->db->affected_rows() > 0) {
                echo "<script>alert('Data berhasil disimpan');
                </script>";
            }
            echo "<script>window.location='" . site_url('User') . "';</script>";
        }
    }
    // FORM EDIT
    public function edit($id)
    {
        $this->form_validation->set_rules('fullname', 'Name', 'required');
        $this->form_validation->set_rules('username', 'Username', 'required|min_length[5]|callback_username_check');
        if ($this->input->post('password')) {
            $this->form_validation->set_rules('password', 'Password', 'min_length[5]');
            $this->form_validation->set_rules(
                'pass-conf',
                'Confirmation Password',
                'matches[password]',
                array('matches' => '%s tidak sesuai dengan password')
            );
        }
        if ($this->input->post('pass-conf')) {
            $this->form_validation->set_rules(
                'pass-conf',
                'Confirmation Password',
                'matches[password]',
                array('matches' => '%s tidak sesuai dengan password')
            );
        }
        $this->form_validation->set_rules('level', 'level', 'required');
        $this->form_validation->set_message('required', '%s masih kosong, silahkan isi');
        $this->form_validation->set_message('min_length', '%s minimal 5 karakter');


        if ($this->form_validation->run() == FALSE) {
            $query = $this->User_m->get($id);
            if ($query->num_rows() > 0) {
                $data['row'] = $query->row();
                $this->template->load('template', 'User/User_form_edit', $data);
            } else {
                echo "<script>alert('Data tidak ditemukan');";
                echo "window.location='" . site_url('User') . "';</script>";
            }
        } else {
            $post = $this->input->post(null, TRUE);
            $this->User_m->edit($post);
            if ($this->db->affected_rows() > 0) {
                echo "<script>alert('Data berhasil disimpan');
                </script>";
            }
            echo "<script>window.location='" . site_url('User') . "';</script>";
        }
    }

    // CALLBACK
    function username_check()
    {
        $post = $this->input->post(null, TRUE);
        $query = $this->db->query("SELECT * FROM users WHERE username ='$post[username]' AND user_id != '$post[user_id]'");
        if ($query->num_rows() > 0) {
            $this->form_validation->set_message('username_check',  '{field} ini sudah dipakai, silahkan ganti');
            return FALSE;
        } else {
            return TRUE;
        }
    }
    // FORM DELETE
    public function del()
    {
        $id = $this->input->post('user_id');
        $this->User_m->del($id);

        if ($this->db->affected_rows() > 0) {
            echo "<script>alert('Data berhasil dihapus');</script>";
        }
        echo "<script>window.location='" . site_url('User') . "';</script>";
    }
}
