<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Kas extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        check_not_login();
        $this->load->model(['Karyawan_m', 'Transaction/Kas_m']);
    }

    // INDEX PINJAM
    public function keluar()
    {
        $data['row'] = $this->Kas_m->get_keluar()->result();
        $this->template->load('template', 'Transaction/Kas/PinjamKas_data', $data);
        $this->load->view('datatables');
    }

    // SELECT KARYAWAN PINJAM FORM
    public function keluar_add()
    {
        $karyawan = $this->Karyawan_m->get_cashier()->result();
        $data = ['karyawan' => $karyawan];
        $this->template->load('template', 'Transaction/Kas/PinjamKas_form', $data);
        $this->load->view('datatables');
    }

    // INDEX BAYAR
    public function masuk()
    {
        $data['row'] = $this->Kas_m->get_masuk()->result();
        $this->template->load('template', 'Transaction/Kas/BayarKas_data', $data);
        $this->load->view('datatables');
    }

    // SELECT KARYAWAN BAYAR FORM
    public function masuk_add()
    {
        $karyawan = $this->Karyawan_m->get_cashier()->result();
        $data = ['karyawan' => $karyawan];
        $this->template->load('template', 'Transaction/Kas/BayarKas_form', $data);
        $this->load->view('datatables');
    }

    // FORM PROSES
    public function process()
    {
        if (isset($_POST['keluar_add'])) {
            $post = $this->input->post(null, TRUE);
            $this->Kas_m->add_keluar($post);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Data berhasil disimpan');
            }
            redirect('Transaction/Kas/keluar');
        } else if (isset($_POST['masuk_add'])) {
            $post = $this->input->post(null, TRUE);
            $this->Kas_m->add_masuk($post);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Data berhasil disimpan');
            }
            redirect('Transaction/Kas/masuk');
        }
    }
    public function masuk_del($id)
    {
        $this->Kas_m->del($id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil DiHapus');
        }
        redirect('Transaction/Kas/masuk');
    }

    public function keluar_del($id)
    {
        $this->Kas_m->del($id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil DiHapus');
        }
        redirect('Transaction/Kas/keluar');
    }
    
    public function export_excel()
    {
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel.php';
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->getProperties()->setCreator("Podiy Beauty");
        $objPHPExcel->getProperties()->setLastModifiedBy("Podiy Beauty");
        $objPHPExcel->getProperties()->setTitle("Data Kas Masuk/ Keluar");
        $objPHPExcel->getProperties()->setSubject("");
        $objPHPExcel->getProperties()->setDescription("");

        $style_col = array(
            'font' => array('bold' => true),
            'aligment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
            ),
            'borders' => array(
                'top' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'right' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'left' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
            )
        );
        
        if (isset($_GET['printexcel']) && !empty($_GET['printexcel'])) { // Cek apakah user telah memilih filter dan klik tombol tampilkan           
            $tgl1 = $_GET['tgl1'];
            $tgl2 = $_GET['tgl2'];
            $product = $this->Kas_m->view_kas($tgl1, $tgl2); // Panggil fungsi view_by_date yang ada di TransaksiModel            
        }
      

        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A1', "DATA KAS MASUK/KELUAR");
        $objPHPExcel->getActiveSheet()->mergeCells('A1:F1');
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->setCellValue('A2', "No");
        $objPHPExcel->getActiveSheet()->setCellValue('B2', "Date");
        $objPHPExcel->getActiveSheet()->setCellValue('C2', "Karyawan");
        $objPHPExcel->getActiveSheet()->setCellValue('D2', "Type");
        $objPHPExcel->getActiveSheet()->setCellValue('E2', "Total");
        $objPHPExcel->getActiveSheet()->setCellValue('F2', "Detail");

        $objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('C2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('D2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('E2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('F2')->applyFromArray($style_col);

        $baris = 3;
        $x = 1;
        foreach ($product as $data) {
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $baris, $x);
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $baris, $data->date);
            $objPHPExcel->getActiveSheet()->setCellValue('C' . $baris, $data->karyawan_name);
            $objPHPExcel->getActiveSheet()->setCellValue('D' . $baris, $data->type);
            $objPHPExcel->getActiveSheet()->setCellValue('E' . $baris, $data->total);
            $objPHPExcel->getActiveSheet()->setCellValue('F' . $baris, $data->keterangan);

            $x++;
            $baris++;
        }
        $filename = "Data_kas_masuk_keluar".".xlsx";
        $objPHPExcel->getActiveSheet()->setTitle("Data Kas Masuk Keluar");

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename=' . $filename);
        header('Cache-Control: max-age=0');

        $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $writer->save('php://output');

        exit;
    }
}
