<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">Product</li>
                    <li class="breadcrumb-item"><a href="<?= site_url('Products/Item') ?>">Data Product</a></li>
                    <li class="breadcrumb-item"><a href="<?= site_url('Transaction/Stock/Out') ?>">Data Stock Out</a></li>
                    <li class="breadcrumb-item active">Add</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- /.container-fluid -->
</section>
<section class="content">
    <?php $this->view('message') ?>

    <div class="container-fluid">
        <div class="col-12">
            <div class="card card-primary">
                <div class="card-header">
                    <span class="float-left">
                        <h2> Stock Out Product</h2>
                    </span>
                    <a href="<?= site_url('Transaction/Stock/Out') ?>" class="btn btn-info float-right">
                        <i class="fa fa-undo"></i> Back
                    </a>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <!-- FORM -->
                    <div class="col-md-4">
                        <form action="<?= site_url('Transaction/Stock/process') ?>" method="post">
                            <div class="card-body">
                                <div class="form-group ">
                                    <label>Date *</label>
                                    <input type="date" name="date" value="<?= date('Y-m-d') ?>" class="form-control">
                                </div>
                                <div>
                                    <label for="item_name">Item Name *</label>
                                </div>
                                <div class="form-group input-group ">
                                    <input type="hidden" name="item_id" id="item_id">
                                    <input type="text" name="item_name" id="item_name" class="form-control" required autofocus>
                                    <span class="input-group-append">
                                        <button type="button" class="btn btn-info btn-default" data-toggle="modal" data-target="#mymodal">
                                            <i class="fas fa-search"></i></i>
                                        </button>
                                    </span>
                                </div>
                                <div class="form-group ">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <label for="detail">Info *</label>
                                            <input type="text" name="detail" class="form-control">
                                        </div>
                                        <div class="col-md-4">
                                            <label for="unit_name">Initial Stock *</label>
                                            <input type="text" name="stock" id="stock" value="-" class="form-control" readonly>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group ">
                                    <label>Qty *</label>
                                    <input type="number" name="qty" class="form-control" required>
                                </div>
                            </div>
                            <!-- /.card-body -->
                            <div class="card-footer form-group">
                                <button type="submit" name="out_add" class="btn btn-primary">Submit </button>
                                <button type="reset" class="btn btn-info float-right">Reset</button>
                            </div>
                        </form>
                    </div>
                    <!-- End Form -->
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->
<div class="modal fade" id="mymodal">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Select Product Item</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table id="example2" class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Price</th>
                            <th>Stock</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($item as $i => $data) { ?>
                            <tr>
                                <td><?= $data->item_name ?> </td>
                                <td class="text-right"><?= indo_currency($data->item_price) ?> </td>
                                <td class="text-right"><?= $data->stock ?> </td>
                                <td class="text-center" style="width:15%">
                                    <button class="btn btn-xs btn-info" id="select" data-id="<?= $data->item_id ?>" data-name="<?= $data->item_name ?>" data-stock="<?= $data->stock ?>">
                                        <i class="fa fa-check">
                                        </i>Select
                                    </button>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>