<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">

            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">Customer</li>
                    <li class="breadcrumb-item"><a href="<?= site_url('Customer/Customer') ?>">Data Customer</a></li>
                    <li class="breadcrumb-item active"><?= ucfirst($page) ?></li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>
<section class="content">
    <div class="container-fluid">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <span class="float-left">
                        <h2><?= ucfirst($page) ?> Customer</h2>
                    </span>
                    <a href="<?= site_url('Customer/Customer') ?>" class="btn btn-info float-right">
                        <i class="fa fa-undo"></i> Back
                    </a>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <!-- FORM -->
                    <div class="col-md-4">
                        <form action="<?= site_url('Customer/Customer/process') ?>" method="post">
                            <div class="card-body">
                                <div class="form-group ">
                                    <label>Customer Name *</label>
                                    <input type="hidden" name="id" value="<?= $row->customer_id ?>">
                                    <input class="form-control" type="text" name="customer_name" value="<?= $row->name ?>" required>
                                </div>
                                <div class="form-group ">
                                    <label>Gender *</label>
                                    <select name="gender" class="form-control custom-select" data-dropdown-css-class="select2-danger" required>
                                        <option value="" selected="selected" disabled>SELECT</option>
                                        <option value="L" <?= $row->gender == 'L' ? 'selected' : '' ?>> Laki-Laki</option>
                                        <option value="P" <?= $row->gender == 'P' ? 'selected' : '' ?>> Perempuan</option>
                                    </select>
                                </div>
                                <div class="form-group ">
                                    <label>Phone *</label>
                                    <input class="form-control" type="text" name="phone" value="<?= $row->phone ?>" required>
                                </div>
                                <div class="form-group ">
                                    <label>Category *</label>
                                    <select name="category" class="form-control custom-select" required>
                                        <option value="" selected="selected" disabled>SELECT</option>
                                        <?php foreach ($category->result() as $key => $data) { ?>
                                            <option value="<?= $data->category_id ?>" <?= $data->category_id == $row->category_id ? "selected" : null ?>><?= $data->name ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="form-group ">
                                    <label>Address *</label>
                                    <textarea class="form-control" name="address" required><?= $row->address ?></textarea>
                                </div>

                            </div>
                            <!-- /.card-body -->
                            <div class="card-footer form-group">
                                <button type="submit" name="<?= $page ?>" class="btn btn-primary">Submit </button>
                                <button type="reset" class="btn btn-info float-right">Reset</button>
                            </div>
                        </form>
                    </div>
                    <!-- End Form -->
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->