<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Stock In Bahan</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">Product</li>
                    <li class="breadcrumb-item"><a href="<?= site_url('Bahan/Bahan') ?>">Data Bahan</a></li>
                    <li class="breadcrumb-item Active">Data Stock In</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<section class="content">
    <?php $this->view('message') ?>
    <div class="container-fluid">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <a href="<?= site_url('Bahan/Stock_bahan/Bahan_in/add') ?>" class="btn btn-primary">
                        <i class="fas fa-plus-circle"></i> <b>Add Stock In</b>
                    </a>
                    <a href="<?= site_url('Bahan/Bahan') ?>" class="btn btn-info float-right">
                        <i class="fa fa-undo"></i> Back
                    </a>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <table id="example2" class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Product Bahan</th>
                                <th>Qty</th>
                                <th>Info</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1;
                            foreach ($row as $key => $data) { ?>
                                <tr>
                                    <td style="width:5%"><?= $no++ ?> </td>
                                    <td><?= $data->bahan_name ?> </td>
                                    <td class="text-right"><?= $data->qty ?> </td>
                                    <td><?= $data->detail ?></td>
                                    <td class="text-center"><?= indo_date($data->date) ?> </td>
                                    <td class="text-center" width="160px">
                                        <a id="set_dtl" class="btn btn-default btn-xs" data-toggle="modal" data-target="#modal-detail" data-bahanname="<?= $data->bahan_name ?>" data-detail="<?= $data->detail ?>" data-qty=" <?= $data->qty ?>" data-date="<?= indo_date($data->date) ?>">
                                            <i class="fa fa-eye"></i> Details
                                        </a>
                                        <a href="<?= site_url('Bahan/Stock_bahan/Bahan_in/del/' . $data->stock_id . '/' . $data->bahan_id) ?>" onclick="return confirm('Yakin hapus data?')" class="btn btn-danger btn-xs">
                                            <i class="fa fa-trash"></i> Delete
                                        </a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->

<!-- MODAL DETAIL STOCK IN -->
<div class="modal fade" id="modal-detail">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Stock In Detail</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body table-responsive">
                <table class="table table-bordered no-margin">
                    <tbody>
                        <tr>
                            <th style="width: 25%;">bahan Name</th>
                            <td><span id="bahan_name"></span></td>
                        </tr>
                        <tr>
                            <th>Info</th>
                            <td><span id="detail"></span></td>
                        </tr>
                        <tr>
                            <th>Qty</th>
                            <td><span id="qty"></span></td>
                        </tr>
                        <tr>
                            <th>Date</th>
                            <td><span id="date"></span></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- END MODAL DETAIL STOCK IN -->