<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Services_m extends CI_Model
{

    // menampilkan data services
    public function get($id = null)
    {
        $this->db->select('p_services.*,  p_category.name as category_name');
        $this->db->from('p_services');
        $this->db->join('p_category', 'p_category.category_id = p_services.category_id');
        if ($id != null) {
            $this->db->where('services_id', $id);
        }
        $query = $this->db->get();
        return $query;
    }

    // menghapus data services
    public function del($id)
    {

        $this->db->where('services_id', $id);
        $this->db->delete('p_services');
    }

    // menambah data services
    public function add($post)
    {
        $params = [
            'services_name' => $post['services_name'],
            'category_id' => $post['category'],
            'services_modal' => $post['services_modal'],
            'services_price' => $post['services_price'],
            'commision' => $post['commision'],

        ];
        $this->db->insert('p_services', $params);
    }
    // mengedit data services
    public function edit($post)
    {
        $params = [
            'services_name' => $post['services_name'],
            'category_id' => $post['category'],
            'services_modal' => $post['services_modal'],
            'services_price' => $post['services_price'],
            'commision' => $post['commision'],
            'updated' => date('Y-m-d H:i:s')
        ];
        $this->db->where('services_id', $post['id']);
        $this->db->update('p_services', $params);
    }
}
