<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Pinjaman extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
       	check_not_login_smd();
        $this->load->model(['Karyawan_m', 'Rpotkaryawan/Pinjaman_m']);
    }

    // INDEX PINJAM
    public function pinjam()
    {
        $data['row'] = $this->Pinjaman_m->get_pinjam()->result();
        $this->template->load('template', 'RpotKaryawan/PinjamUang/PinjamUang_data', $data);
        $this->load->view('datatables');
    }

    // SELECT KARYAWAN PINJAM FORM
    public function pinjam_add()
    {
        $karyawan = $this->Karyawan_m->get()->result();
        $data = ['karyawan' => $karyawan];
        $this->template->load('template', 'RpotKaryawan/PinjamUang/PinjamUang_form', $data);
        $this->load->view('datatables');
    }

    // INDEX BAYAR
    public function bayar()
    {
        $data['row'] = $this->Pinjaman_m->get_bayar()->result();
        $this->template->load('template', 'RpotKaryawan/PinjamUang/BayarUang_data', $data);
        $this->load->view('datatables');
    }

    // SELECT KARYAWAN BAYAR FORM
    public function bayar_add()
    {
        $karyawan = $this->Karyawan_m->get()->result();
        $data = ['karyawan' => $karyawan];
        $this->template->load('template', 'RpotKaryawan/PinjamUang/BayarUang_form', $data);
        $this->load->view('datatables');
    }

    // FORM PROSES
    public function process()
    {
        if (isset($_POST['pinjam_add'])) {
            $post = $this->input->post(null, TRUE);
            $this->Pinjaman_m->add_pinjam($post);
            $this->Karyawan_m->update_pinjaman_pinjam($post);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Data berhasil disimpan');
            }
            redirect('Rpotkaryawan/Pinjaman/pinjam');
        } else if (isset($_POST['bayar_add'])) {
            $post = $this->input->post(null, TRUE);
            $this->Pinjaman_m->add_bayar($post);
            $this->Karyawan_m->update_pinjaman_bayar($post);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Data berhasil disimpan');
            }
            redirect('Rpotkaryawan/Pinjaman/bayar');
        }
    }

    public function bayar_del()
    {
        $pinjaman_id = $this->uri->segment(5);
        $karyawan_id = $this->uri->segment(6);
        $pinjaman = $this->Pinjaman_m->get($pinjaman_id)->row()->pinjaman;
        $data = ['pinjaman' => $pinjaman, 'karyawan_id' => $karyawan_id];
        $this->Karyawan_m->update_pinjaman_pinjam($data);
        $this->Pinjaman_m->del($pinjaman_id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data berhasil dihapus');
        }
        redirect('Rpotkaryawan/Pinjaman/bayar');
    }

    public function pinjam_del()
    {
        $pinjaman_id = $this->uri->segment(5);
        $karyawan_id = $this->uri->segment(6);
        $pinjaman = $this->Pinjaman_m->get($pinjaman_id)->row()->pinjaman;
        $data = ['pinjaman' => $pinjaman, 'karyawan_id' => $karyawan_id];
        $this->Karyawan_m->update_pinjaman_bayar($data);
        $this->Pinjaman_m->del($pinjaman_id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data berhasil dihapus');
        }
        redirect('Rpotkaryawan/Pinjaman/pinjam');
    }
}
