<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Report extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
       	check_not_login_smd();
        $this->load->model('Transaction/Sales_m');
    }


    // REPORT SERVICE
    public function index()
    {
        $data['row'] = $this->Sales_m->get_sale();
        $this->template->load('template', 'Report/report_data', $data);
        $this->load->view('datatables');
    }

    // REPORT PRODUCT
    public function report_item()
    {
        $data['row'] = $this->Sales_m->get_sale_item();
        $this->template->load('template', 'Report/report_data_item', $data);
        $this->load->view('datatables');
    }

    // GET DETAIL SERVICE
    public function sale_service($sale_id = null)
    {
        $detail = $this->Sales_m->get_sale_detail($sale_id);
        if ($detail->num_rows() > 0) {
            $item = $detail->result_array();
            array_walk_recursive($item, function (&$item) {
                $item = strval($item);
            });
            echo json_encode($item);
        }
    }

    // GET DETAIL PRODUCT
    public function sale_product($sale_id = null)
    {
        $detail = $this->Sales_m->get_sale_detail_item($sale_id);
        if ($detail->num_rows() > 0) {
            $item = $detail->result_array();
            array_walk_recursive($item, function (&$item) {
                $item = strval($item);
            });
            echo json_encode($item);
        }
    }

    public function move_refund($id)
    {
        $this->Sales_m->move_refund($id);
        $this->Sales_m->move_refund_detail($id);
        $this->Sales_m->del_sale_item($id);
        if ($this->db->affected_rows() > 0) {
            echo "<script>alert('Refund Berhasil');
            window.location='" . site_url('refund') . "';</script>";
        }
    }

    public function refund()
    {
        $data['row'] = $this->Sales_m->get_refund();
        $this->template->load('template', 'Report/refund', $data);
        $this->load->view('datatables');
    }

    public function refund_product($sale_id = null)
    {
        $detail = $this->Sales_m->get_refund_detail($sale_id);
        if ($detail->num_rows() > 0) {
            $item = $detail->result_array();
            array_walk_recursive($item, function (&$item) {
                $item = strval($item);
            });
            echo json_encode($item);
        }
    }

    public function export_excel()
    {
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel.php';
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->getProperties()->setCreator("Podiy Beauty");
        $objPHPExcel->getProperties()->setLastModifiedBy("Podiy Beauty");
        $objPHPExcel->getProperties()->setTitle("Data Report Product");
        $objPHPExcel->getProperties()->setSubject("");
        $objPHPExcel->getProperties()->setDescription("");

        $style_col = array(
            'font' => array('bold' => true),
            'aligment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
            ),
            'borders' => array(
                'top' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'right' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'left' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
            )
        );

        if (isset($_GET['cetak']) && !empty($_GET['cetak'])) { // Cek apakah user telah memilih filter dan klik tombol tampilkan           
            $tgl1 = $_GET['tgl1'];
            $tgl2 = $_GET['tgl2'];
            $product = $this->Sales_m->view_product($tgl1, $tgl2); // Panggil fungsi view_by_date yang ada di TransaksiModel            
        }

        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A1', "DATA PENJUALAN PRODUCT");
        $objPHPExcel->getActiveSheet()->mergeCells('A1:L1');
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->setCellValue('A2', "NO");
        $objPHPExcel->getActiveSheet()->setCellValue('B2', "Date");
        $objPHPExcel->getActiveSheet()->setCellValue('C2', "Invoice");
        $objPHPExcel->getActiveSheet()->setCellValue('D2', "Cashier Name");
        $objPHPExcel->getActiveSheet()->setCellValue('E2', "Customer Name");
        $objPHPExcel->getActiveSheet()->setCellValue('F2', "Sub Total");
        $objPHPExcel->getActiveSheet()->setCellValue('G2', "Discount");
        $objPHPExcel->getActiveSheet()->setCellValue('H2', "Total");
        $objPHPExcel->getActiveSheet()->setCellValue('I2', "Cash");
        $objPHPExcel->getActiveSheet()->setCellValue('J2', "Change");
        $objPHPExcel->getActiveSheet()->setCellValue('K2', "Point");
        $objPHPExcel->getActiveSheet()->setCellValue('L2', "Method");

        $objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('C2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('D2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('E2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('F2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('G2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('H2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('I2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('J2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('K2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('L2')->applyFromArray($style_col);


        $baris = 3;
        $x = 1;
        foreach ($product as $data) {
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $baris, $x);
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $baris, indo_date($data->date));
            $objPHPExcel->getActiveSheet()->setCellValue('C' . $baris, $data->invoice);
            $objPHPExcel->getActiveSheet()->setCellValue('D' . $baris, $data->karyawan_name);
            $objPHPExcel->getActiveSheet()->setCellValue('E' . $baris, $data->customer_name);
            $objPHPExcel->getActiveSheet()->setCellValue('F' . $baris, $data->total_price);
            $objPHPExcel->getActiveSheet()->setCellValue('G' . $baris, $data->discount);
            $objPHPExcel->getActiveSheet()->setCellValue('H' . $baris, $data->final_price);
            $objPHPExcel->getActiveSheet()->setCellValue('I' . $baris, $data->cash);
            $objPHPExcel->getActiveSheet()->setCellValue('J' . $baris, $data->remaining);
            $objPHPExcel->getActiveSheet()->setCellValue('K' . $baris, $data->point);
            $objPHPExcel->getActiveSheet()->setCellValue('L' . $baris, $data->method);

            $x++;
            $baris++;
        }
        $filename = "Data" . ".xlsx";
        $objPHPExcel->getActiveSheet()->setTitle("Data Product");

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename=' . $filename);
        header('Cache-Control: max-age=0');

        $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $writer->save('php://output');

        exit;
    }

    public function export_detail_excel()
    {
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel.php';
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->getProperties()->setCreator("Podiy Beauty");
        $objPHPExcel->getProperties()->setLastModifiedBy("Podiy Beauty");
        $objPHPExcel->getProperties()->setTitle("Data Detail Report Product");
        $objPHPExcel->getProperties()->setSubject("");
        $objPHPExcel->getProperties()->setDescription("");

        $style_col = array(
            'font' => array('bold' => true),
            'aligment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
            ),
            'borders' => array(
                'top' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'right' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'left' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
            )
        );

        if (isset($_GET['print'])) { // Cek apakah user telah memilih filter dan klik tombol tampilkan           
            $tgl_dtl1 = $_GET['tgl_dtl1'];
            $tgl_dtl2 = $_GET['tgl_dtl2'];
            $product = $this->Sales_m->view_product_detail($tgl_dtl1, $tgl_dtl2); // Panggil fungsi view_by_date yang ada di TransaksiModel            
        }

        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A1', "DATA DETAIL PENJUALAN PRODUCT");
        $objPHPExcel->getActiveSheet()->mergeCells('A1:G1');
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->setCellValue('A2', "NO");
        $objPHPExcel->getActiveSheet()->setCellValue('B2', "Date");
        $objPHPExcel->getActiveSheet()->setCellValue('C2', "Product Name");
        $objPHPExcel->getActiveSheet()->setCellValue('D2', "SubTotal");
        $objPHPExcel->getActiveSheet()->setCellValue('E2', "Qty");
        $objPHPExcel->getActiveSheet()->setCellValue('F2', "Discount %");
        $objPHPExcel->getActiveSheet()->setCellValue('G2', "Total");

        $objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('C2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('D2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('E2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('F2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('G2')->applyFromArray($style_col);

        $baris = 3;
        $x = 1;
        foreach ($product as $data) {
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $baris, $x);
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $baris, indo_date($data->date));
            $objPHPExcel->getActiveSheet()->setCellValue('C' . $baris, $data->item_name);
            $objPHPExcel->getActiveSheet()->setCellValue('D' . $baris, $data->detail_price);
            $objPHPExcel->getActiveSheet()->setCellValue('E' . $baris, $data->qty);
            $objPHPExcel->getActiveSheet()->setCellValue('F' . $baris, $data->discount_item);
            $objPHPExcel->getActiveSheet()->setCellValue('G' . $baris, $data->total);

            $x++;
            $baris++;
        }
        $filename = "Data_Product_Detail" . ".xlsx";
        $objPHPExcel->getActiveSheet()->setTitle("Data Product Detail");

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename=' . $filename);
        header('Cache-Control: max-age=0');

        $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $writer->save('php://output');

        exit;
    }

    public function export_service()
    {
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel.php';
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->getProperties()->setCreator("Podiy Beauty");
        $objPHPExcel->getProperties()->setLastModifiedBy("Podiy Beauty");
        $objPHPExcel->getProperties()->setTitle("Data Report Product");
        $objPHPExcel->getProperties()->setSubject("");
        $objPHPExcel->getProperties()->setDescription("");

        $style_col = array(
            'font' => array('bold' => true),
            'aligment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
            ),
            'borders' => array(
                'top' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'right' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'left' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
            )
        );

        if (isset($_GET['cetak']) && !empty($_GET['cetak'])) { // Cek apakah user telah memilih filter dan klik tombol tampilkan           
            $tgl1 = $_GET['tgl1'];
            $tgl2 = $_GET['tgl2'];
            $product = $this->Sales_m->view_service($tgl1, $tgl2); // Panggil fungsi view_by_date yang ada di TransaksiModel            
        }

        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A1', "DATA PENJUALAN JASA SERVICE");
        $objPHPExcel->getActiveSheet()->mergeCells('A1:M1');
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->setCellValue('A2', "NO");
        $objPHPExcel->getActiveSheet()->setCellValue('B2', "Date");
        $objPHPExcel->getActiveSheet()->setCellValue('C2', "Invoice");
        $objPHPExcel->getActiveSheet()->setCellValue('D2', "Cashier Name");
        $objPHPExcel->getActiveSheet()->setCellValue('F2', "Customer Name");
        $objPHPExcel->getActiveSheet()->setCellValue('G2', "Sub Total");
        $objPHPExcel->getActiveSheet()->setCellValue('H2', "Discount");
        $objPHPExcel->getActiveSheet()->setCellValue('I2', "Total");
        $objPHPExcel->getActiveSheet()->setCellValue('J2', "Cash");
        $objPHPExcel->getActiveSheet()->setCellValue('K2', "Change");
        $objPHPExcel->getActiveSheet()->setCellValue('L2', "Point");
        $objPHPExcel->getActiveSheet()->setCellValue('M2', "Method");


        $objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('C2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('D2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('E2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('F2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('G2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('H2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('I2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('J2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('K2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('L2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('M2')->applyFromArray($style_col);



        $baris = 3;
        $x = 1;
        foreach ($product as $data) {
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $baris, $x);
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $baris, indo_date($data->date));
            $objPHPExcel->getActiveSheet()->setCellValue('C' . $baris, $data->invoice);
            $objPHPExcel->getActiveSheet()->setCellValue('D' . $baris, $data->karyawan_name);
            $objPHPExcel->getActiveSheet()->setCellValue('F' . $baris, $data->customer_name);
            $objPHPExcel->getActiveSheet()->setCellValue('G' . $baris, $data->total_price);
            $objPHPExcel->getActiveSheet()->setCellValue('H' . $baris, $data->discount);
            $objPHPExcel->getActiveSheet()->setCellValue('I' . $baris, $data->final_price);
            $objPHPExcel->getActiveSheet()->setCellValue('J' . $baris, $data->cash);
            $objPHPExcel->getActiveSheet()->setCellValue('K' . $baris, $data->remaining);
            $objPHPExcel->getActiveSheet()->setCellValue('L' . $baris, $data->point);
            $objPHPExcel->getActiveSheet()->setCellValue('M' . $baris, $data->method);


            $x++;
            $baris++;
        }
        $filename = "Data_penjualan_jasa_service" . ".xlsx";
        $objPHPExcel->getActiveSheet()->setTitle("Data Penjualan Jasa Service");

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename=' . $filename);
        header('Cache-Control: max-age=0');

        $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $writer->save('php://output');

        exit;
    }

    public function export_detail_service()
    {
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel.php';
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->getProperties()->setCreator("Podiy Beauty");
        $objPHPExcel->getProperties()->setLastModifiedBy("Podiy Beauty");
        $objPHPExcel->getProperties()->setTitle("Data Detail Service");
        $objPHPExcel->getProperties()->setSubject("");
        $objPHPExcel->getProperties()->setDescription("");

        $style_col = array(
            'font' => array('bold' => true),
            'aligment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
            ),
            'borders' => array(
                'top' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'right' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'left' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
            )
        );

        if (isset($_GET['printexcel']) && !empty($_GET['printexcel'])) { // Cek apakah user telah memilih filter dan klik tombol tampilkan           
            $tglservice1 = $_GET['tglservice1'];
            $tglservice2 = $_GET['tglservice2'];
            $service = $this->Sales_m->view_detail_service($tglservice1, $tglservice2); // Panggil fungsi view_by_date yang ada di TransaksiModel            
        }

        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A1', "DATA DETAIL PENJUALAN JASA SERVICE");
        $objPHPExcel->getActiveSheet()->mergeCells('A1:J1');
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->setCellValue('A2', "NO");
        $objPHPExcel->getActiveSheet()->setCellValue('B2', "Date");
        $objPHPExcel->getActiveSheet()->setCellValue('C2', "Service");
        $objPHPExcel->getActiveSheet()->setCellValue('D2', "Terapis");
        $objPHPExcel->getActiveSheet()->setCellValue('E2', "Bahan");
        $objPHPExcel->getActiveSheet()->setCellValue('F2', "Komisi");
        $objPHPExcel->getActiveSheet()->setCellValue('G2', "Sub Total");
        $objPHPExcel->getActiveSheet()->setCellValue('H2', "Qty");
        $objPHPExcel->getActiveSheet()->setCellValue('I2', "Discount %");
        $objPHPExcel->getActiveSheet()->setCellValue('J2', "Total");


        $objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('C2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('D2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('E2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('F2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('G2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('H2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('I2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('J2')->applyFromArray($style_col);
       



        $baris = 3;
        $x = 1;
        foreach ($service as $data) {
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $baris, $x);
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $baris, indo_date($data->date));
            $objPHPExcel->getActiveSheet()->setCellValue('C' . $baris, $data->services_name);
            $objPHPExcel->getActiveSheet()->setCellValue('D' . $baris, $data->kry_name);
            $objPHPExcel->getActiveSheet()->setCellValue('E' . $baris, $data->bahan_name);
            $objPHPExcel->getActiveSheet()->setCellValue('F' . $baris, $data->commision);
            $objPHPExcel->getActiveSheet()->setCellValue('G' . $baris, $data->detail_price);
            $objPHPExcel->getActiveSheet()->setCellValue('H' . $baris, $data->qty);
            $objPHPExcel->getActiveSheet()->setCellValue('I' . $baris, $data->discount_item);
            $objPHPExcel->getActiveSheet()->setCellValue('J' . $baris, $data->total);


            $x++;
            $baris++;
        }
        $filename = "data_penjualan_jasa_service_detail" . ".xlsx";
        $objPHPExcel->getActiveSheet()->setTitle("Service Detail");

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename=' . $filename);
        header('Cache-Control: max-age=0');

        $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $writer->save('php://output');

        exit;
    }

    public function export_refund()
    {
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel.php';
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->getProperties()->setCreator("Podiy Beauty");
        $objPHPExcel->getProperties()->setLastModifiedBy("Podiy Beauty");
        $objPHPExcel->getProperties()->setTitle("Data Report Refund Product");
        $objPHPExcel->getProperties()->setSubject("");
        $objPHPExcel->getProperties()->setDescription("");

        $style_col = array(
            'font' => array('bold' => true),
            'aligment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
            ),
            'borders' => array(
                'top' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'right' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'left' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
            )
        );

        if (isset($_GET['cetak']) && !empty($_GET['cetak'])) { // Cek apakah user telah memilih filter dan klik tombol tampilkan           
            $tgl1 = $_GET['tgl1'];
            $tgl2 = $_GET['tgl2'];
            $product = $this->Sales_m->view_refund($tgl1, $tgl2); // Panggil fungsi view_by_date yang ada di TransaksiModel            
        }

        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A1', "DATA REFUND PENJUALAN PRODUCT");
        $objPHPExcel->getActiveSheet()->mergeCells('A1:M1');
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->setCellValue('A2', "NO");
        $objPHPExcel->getActiveSheet()->setCellValue('B2', "Date");
        $objPHPExcel->getActiveSheet()->setCellValue('C2', "Invoice");
        $objPHPExcel->getActiveSheet()->setCellValue('D2', "Cashier Name");
        $objPHPExcel->getActiveSheet()->setCellValue('E2', "Customer Name");
        $objPHPExcel->getActiveSheet()->setCellValue('F2', "Sub Total");
        $objPHPExcel->getActiveSheet()->setCellValue('G2', "Discount");
        $objPHPExcel->getActiveSheet()->setCellValue('H2', "Total");
        $objPHPExcel->getActiveSheet()->setCellValue('I2', "Cash");
        $objPHPExcel->getActiveSheet()->setCellValue('J2', "Change");
        $objPHPExcel->getActiveSheet()->setCellValue('K2', "Point");
        $objPHPExcel->getActiveSheet()->setCellValue('L2', "Method");

        $objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('C2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('D2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('E2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('F2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('G2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('H2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('I2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('J2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('K2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('L2')->applyFromArray($style_col);


        $baris = 3;
        $x = 1;
        foreach ($product as $data) {
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $baris, $x);
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $baris, indo_date($data->date));
            $objPHPExcel->getActiveSheet()->setCellValue('C' . $baris, $data->invoice);
            $objPHPExcel->getActiveSheet()->setCellValue('D' . $baris, $data->karyawan_name);
            $objPHPExcel->getActiveSheet()->setCellValue('E' . $baris, $data->customer_name);
            $objPHPExcel->getActiveSheet()->setCellValue('F' . $baris, $data->total_price);
            $objPHPExcel->getActiveSheet()->setCellValue('G' . $baris, $data->discount);
            $objPHPExcel->getActiveSheet()->setCellValue('H' . $baris, $data->final_price);
            $objPHPExcel->getActiveSheet()->setCellValue('I' . $baris, $data->cash);
            $objPHPExcel->getActiveSheet()->setCellValue('J' . $baris, $data->remaining);
            $objPHPExcel->getActiveSheet()->setCellValue('K' . $baris, $data->point);
            $objPHPExcel->getActiveSheet()->setCellValue('L' . $baris, $data->method);

            $x++;
            $baris++;
        }
        $filename = "Data_Refund_Product" . ".xlsx";
        $objPHPExcel->getActiveSheet()->setTitle("Data Refund Product");

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename=' . $filename);
        header('Cache-Control: max-age=0');

        $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $writer->save('php://output');

        exit;
    }

    public function export_detail_refund()
    {
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel.php';
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->getProperties()->setCreator("Podiy Beauty");
        $objPHPExcel->getProperties()->setLastModifiedBy("Podiy Beauty");
        $objPHPExcel->getProperties()->setTitle("Data Detail Report Refund Product");
        $objPHPExcel->getProperties()->setSubject("");
        $objPHPExcel->getProperties()->setDescription("");

        $style_col = array(
            'font' => array('bold' => true),
            'aligment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
            ),
            'borders' => array(
                'top' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'right' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'left' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
            )
        );

        if (isset($_GET['cetak']) && !empty($_GET['cetak'])) { // Cek apakah user telah memilih filter dan klik tombol tampilkan           
            $tgl1 = $_GET['tgl1'];
            $tgl2 = $_GET['tgl2'];
            $product = $this->Sales_m->view_detail_refund($tgl1, $tgl2); // Panggil fungsi view_by_date yang ada di TransaksiModel            
        }

        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A1', "DATA DETAIL PENJUALAN REFUND PRODUCT");
        $objPHPExcel->getActiveSheet()->mergeCells('A1:G1');
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->setCellValue('A2', "NO");
        $objPHPExcel->getActiveSheet()->setCellValue('B2', "Date");
        $objPHPExcel->getActiveSheet()->setCellValue('C2', "Product Name");
        $objPHPExcel->getActiveSheet()->setCellValue('D2', "SubTotal");
        $objPHPExcel->getActiveSheet()->setCellValue('E2', "Qty");
        $objPHPExcel->getActiveSheet()->setCellValue('F2', "Discount %");
        $objPHPExcel->getActiveSheet()->setCellValue('G2', "Total");

        $objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('C2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('D2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('E2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('F2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('G2')->applyFromArray($style_col);

        $baris = 3;
        $x = 1;
        foreach ($product as $data) {
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $baris, $x);
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $baris, indo_date($data->date));
            $objPHPExcel->getActiveSheet()->setCellValue('C' . $baris, $data->item_name);
            $objPHPExcel->getActiveSheet()->setCellValue('D' . $baris, $data->detail_price);
            $objPHPExcel->getActiveSheet()->setCellValue('E' . $baris, $data->qty);
            $objPHPExcel->getActiveSheet()->setCellValue('F' . $baris, $data->discount_item);
            $objPHPExcel->getActiveSheet()->setCellValue('G' . $baris, $data->total);

            $x++;
            $baris++;
        }
        $filename = "data_detail_refund_product" . ".xlsx";
        $objPHPExcel->getActiveSheet()->setTitle("Data Product Detail");

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename=' . $filename);
        header('Cache-Control: max-age=0');

        $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $writer->save('php://output');

        exit;
    }
}
