<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Services extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
     	check_not_login_smd();
        $this->load->model(['Products/Services_m', 'Products/Categories_m']);
    }

    public function index()
    {
        $data['row'] = $this->Services_m->get();
        $this->template->load('template', 'Products/Services/Services_data', $data);
        $this->load->view('datatables');
    }
    // FORM ADD
    public function add()
    {
        $services = new stdClass();
        $services->services_id = null;
        $services->services_name = null;
        $services->category_id = null;
        $services->services_modal = null;
        $services->services_price = null;
        $services->commision = null;
        $query_categories = $this->Categories_m->get();

        $data = array(
            'page' => 'add',
            'row' => $services,
            'categories' => $query_categories,
        );
        $this->template->load('template', 'Products/Services/Services_form', $data);
    }

    // form edit
    public function edit($id)
    {
        $query = $this->Services_m->get($id);
        if ($query->num_rows() > 0) {
            $services = $query->row();
            $query_categories = $this->Categories_m->get();
            $data = array(
                'page' => 'edit',
                'row' => $services,
                'categories' => $query_categories,
            );
            $this->template->load('template', 'Products/Services/Services_form', $data);
        } else {
            echo "<script>alert('Data tidak ditemukan');";
            echo "window.location='" . site_url('Products/Services') . "';</script>";
        }
    }

    // FORM PROSES
    public function process()
    {
        $post = $this->input->post(null, True);
        if (isset($_POST['add'])) {
            $this->Services_m->add($post);
        } else if (isset($_POST['edit'])) {
            $this->Services_m->edit($post);
        }
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil Disimpan');
        }
        redirect('Products/Services');
    }
    // FORM DELETE
    public function del($id)
    {
        $this->Services_m->del($id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil DiHapus');
        }
        redirect('Products/Services');
    }
}
