<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Customer extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
     	check_not_login_smd();
        $this->load->model(['Customer/Customer_m', 'Customer/C_Category_m']);
    }

    public function index()
    {
        $data['row'] = $this->Customer_m->get();
        $this->template->load('template', 'Customer/Customer_data', $data);
        $this->load->view('datatables');
    }

    public function sale($Customer_id = null)
    {
        $detail = $this->Sales_m->sale_detail($Customer_id)->result();
        echo json_encode($detail);
    }

    // FORM DELETE
    public function del($id)
    {
        $this->Customer_m->del($id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil Dihapus');
        }
        redirect('Customer/Customer');
    }

    // FORM ADD
    public function add()
    {
        $Customer = new stdClass();
        $Customer->customer_id = null;
        $Customer->name = null;
        $Customer->gender = null;
        $Customer->phone = null;
        $Customer->address = null;
        $Customer->category_id = null;
        $query_category = $this->C_Category_m->get();
        $data = array(
            'page' => 'add',
            'row' => $Customer,
            'category' => $query_category,
        );
        $this->template->load('template', 'Customer/Customer_form', $data);
    }

    // FORM ADD LEWAT SALES
    public function add2()
    {
        $Customer = new stdClass();
        $Customer->customer_id = null;
        $Customer->name = null;
        $Customer->gender = null;
        $Customer->phone = null;
        $Customer->address = null;
        $Customer->category_id = null;
        $query_category = $this->C_Category_m->get();
        $data = array(
            'page' => 'add',
            'row' => $Customer,
            'category' => $query_category,
        );
        $this->template->load('template', 'Transaction/C_form', $data);
    }

    // form edit
    public function edit($id)
    {
        $query = $this->Customer_m->get($id);
        if ($query->num_rows() > 0) {
            $Customer = $query->row();
            $query_category = $this->C_Category_m->get();
            $data = array(
                'page' => 'edit',
                'row' => $Customer,
                'category' => $query_category,

            );
            $this->template->load('template', 'Customer/Customer_form', $data);
        } else {
            echo "<script>alert('Data tidak ditemukan');";
            echo "window.location='" . site_url('Customer/Customer') . "';</script>";
        }
    }

    // FORM PROSES
    public function process()
    {
        $post = $this->input->post(null, True);
        if (isset($_POST['add'])) {
            $this->Customer_m->add($post);
        } else if (isset($_POST['edit'])) {
            $this->Customer_m->edit($post);
        }
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil Disimpan');
        }
        echo "<script>window.location='" . site_url('Customer/Customer') . "';</script>";
    }

    public function process2()
    {
        $post = $this->input->post(null, True);
        if (isset($_POST['add'])) {
            $this->Customer_m->add($post);
        }
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil Disimpan');
        }
        echo "<script>window.location='" . site_url('Transaction/Sales') . "';</script>";
    }

    public function process3()
    {
        $post = $this->input->post(null, True);
        if (isset($_POST['add'])) {
            $this->Customer_m->add($post);
        }
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil Disimpan');
        }
        echo "<script>window.location='" . site_url('Transaction/Sales_item') . "';</script>";
    }

    public function export_excel()
    {
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel.php';
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->getProperties()->setCreator("Podiy Beauty");
        $objPHPExcel->getProperties()->setLastModifiedBy("Podiy Beauty");
        $objPHPExcel->getProperties()->setTitle("Data Stock Product");
        $objPHPExcel->getProperties()->setSubject("");
        $objPHPExcel->getProperties()->setDescription("");

        $style_col = array(
            'font' => array('bold' => true),
            'aligment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
            ),
            'borders' => array(
                'top' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'right' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'left' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
            )
        );

        $product = $this->Customer_m->view_Customer(); // Panggil fungsi view_by_date yang ada di TransaksiModel            

        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A1', "DATA CUSTOMER");
        $objPHPExcel->getActiveSheet()->mergeCells('A1:G1');
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->setCellValue('A2', "NO");
        $objPHPExcel->getActiveSheet()->setCellValue('B2', "Name");
        $objPHPExcel->getActiveSheet()->setCellValue('C2', "Gender");
        $objPHPExcel->getActiveSheet()->setCellValue('D2', "Phone");
        $objPHPExcel->getActiveSheet()->setCellValue('E2', "Address");
        $objPHPExcel->getActiveSheet()->setCellValue('F2', "Category");
        $objPHPExcel->getActiveSheet()->setCellValue('G2', "Point");

        $objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('C2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('D2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('E2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('F2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('G2')->applyFromArray($style_col);


        $baris = 3;
        $x = 1;
        foreach ($product as $data) {
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $baris, $x);
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $baris, $data->cust_name);
            $objPHPExcel->getActiveSheet()->setCellValue('C' . $baris, $data->gender == 'L' ? "Laki Laki" : "Perempuan");
            $objPHPExcel->getActiveSheet()->setCellValue('D' . $baris, $data->phone);
            $objPHPExcel->getActiveSheet()->setCellValue('E' . $baris, $data->address);
            $objPHPExcel->getActiveSheet()->setCellValue('F' . $baris, $data->category_name);
            $objPHPExcel->getActiveSheet()->setCellValue('G' . $baris, $data->point);

            $x++;
            $baris++;
        }
        $filename = "Data Customer".".xlsx";
        $objPHPExcel->getActiveSheet()->setTitle("Data Customer");

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename=' . $filename);
        header('Cache-Control: max-age=0');

        $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $writer->save('php://output');

        exit;
    }
}
