<?php
defined('BASEPATH') or exit('No direct script access allowed');

class C_Category extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
      	check_not_login_smd();
        $this->load->model('Customer/C_Category_m');
    }

    public function index()
    {
        $data['row'] = $this->C_Category_m->get();
        $this->template->load('template', 'Customer/C_Category/C_Category_data', $data);
        $this->load->view('datatables');
    }
    // FORM ADD
    public function add()
    {
        $category = new stdClass();
        $category->category_id = null;
        $category->name = null;
        $data = array(
            'page' => 'add',
            'row' => $category
        );
        $this->template->load('template', 'Customer/C_Category/C_Category_form', $data);
    }

    // form edit
    public function edit($id)
    {
        $query = $this->C_Category_m->get($id);
        if ($query->num_rows() > 0) {
            $c_category = $query->row();
            $data = array(
                'page' => 'edit',
                'row' => $c_category
            );
            $this->template->load('template', 'Customer/C_Category/C_Category_form', $data);
        } else {
            echo "<script>alert('Data tidak ditemukan');";
            echo "window.location='" . site_url('Customer/C_Category') . "';</script>";
        }
    }

    // FORM PROSES
    public function process()
    {
        $post = $this->input->post(null, True);
        if (isset($_POST['add'])) {
            $this->C_Category_m->add($post);
        } else if (isset($_POST['edit'])) {
            $this->C_Category_m->edit($post);
        }
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil Disimpan');
        }
        redirect('Customer/C_Category');
    }

    // FORM DELETE
    public function del($id)
    {
        $this->C_Category_m->del($id);
        $error = $this->db->error();
        if ($error['code'] != 0) {
            echo "<script>alert('Data tidak dapat dihapus (sudah berelasi)');</script>";
        } else {
            echo "<script>alert('Data berhasil dihapus');</script>";
        }
        echo "<script>window.location='" . site_url('Customer/C_Category') . "';</script>";
    }
}
