<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Stock_bahan extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
      	check_not_login_smd();
        $this->load->model(['Bahan/Bahan_m', 'Bahan/Stock_bahan_m']);
    }
    // tampil data index
    public function stock_in_data()
    {
        $data['row'] = $this->Stock_bahan_m->get_stock_in()->result();
        $this->template->load('template', 'Bahan/Stock_in/Stock_in_data', $data);
        $this->load->view('datatables');
    }
    // tampil data form
    public function stock_in_add()
    {
        $bahan = $this->Bahan_m->get()->result();
        $data = ['bahan' => $bahan];
        $this->template->load('template', 'Bahan/Stock_in/Stock_in_form', $data);
        $this->load->view('datatables');
    }

    // form delete stock in
    public function stock_in_del()
    {
        $stock_id = $this->uri->segment(5);
        $bahan_id = $this->uri->segment(6);
        $qty = $this->Stock_bahan_m->get($stock_id)->row()->qty;
        $data = ['qty' => $qty, 'bahan_id' => $bahan_id];
        $this->Bahan_m->update_stock_out($data);
        $this->Stock_bahan_m->del($stock_id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Stock-In berhasil dihapus');
        }
        redirect('Bahan/Stock_bahan/Bahan_in');
    }


    // FORM PROSES
    public function process()
    {
        if (isset($_POST['in_add'])) {
            $post = $this->input->post(null, TRUE);
            $this->Stock_bahan_m->add_stock_in($post);
            $this->Bahan_m->update_stock_in($post);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Data Stock-In berhasil disimpan');
            }
            redirect('Bahan/Stock_bahan/Bahan_in');
        } else if (isset($_POST['out_add'])) {
            $post = $this->input->post(null, TRUE);
            $row_bahan = $this->Bahan_m->get($this->input->post('bahan_id'))->row();
            if ($row_bahan->stock < $this->input->post('qty')) {
                $this->session->set_flashdata('error', 'Qty melebihi stock barang');
                redirect('Bahan/Stock_bahan/Bahan_out/add');
            } else {
                $this->Stock_bahan_m->add_stock_out($post);
                $this->Bahan_m->update_stock_out($post);
                if ($this->db->affected_rows() > 0) {
                    $this->session->set_flashdata('success', 'Data Stock-Out berhasil disimpan');
                }
                redirect('Bahan/Stock_bahan/Bahan_out');
            }
        }
    }
    // index stock out
    public function stock_out_data()
    {
        $data['row'] = $this->Stock_bahan_m->get_stock_out()->result();
        $this->template->load('template', 'Bahan/Stock_Out/stock_out_data', $data);
        $this->load->view('datatables');
    }
    // form tambah stock out
    public function stock_out_add()
    {
        $bahan = $this->Bahan_m->get()->result();
        $data = ['bahan' => $bahan];
        $this->template->load('template', 'Bahan/Stock_Out/stock_out_form', $data);
        $this->load->view('datatables');
    }
    // del stock out
    public function stock_out_del()
    {
        $stock_id = $this->uri->segment(5);
        $bahan_id = $this->uri->segment(6);
        $qty = $this->Stock_bahan_m->get($stock_id)->row()->qty;
        $data = ['qty' => $qty, 'bahan_id' => $bahan_id];
        $this->Bahan_m->update_stock_in($data);
        $this->Stock_bahan_m->del($stock_id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Stock-Out berhasil dihapus');
        }
        redirect('Bahan/Stock_bahan/Bahan_out');
    }
}
