<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Stock Out Product</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">Product</li>
                    <li class="breadcrumb-item"><a href="<?= site_url('Products/Item') ?>">Data Product</a></li>
                    <li class="breadcrumb-item active">Data Stock Out</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<section class="content">
    <?php $this->view('message') ?>
    <div class="container-fluid">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <a href="<?= site_url('Transaction/Stock/Out/add') ?>" class="btn btn-primary">
                        <i class="fas fa-plus-circle"></i> <b>Add Stock Out</b>
                    </a>
                    <a href="<?= site_url('Products/Item') ?>" class="btn btn-info float-right">
                        <i class="fa fa-undo"></i> Back
                    </a>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <table id="example2" class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Product Item</th>
                                <th>Qty</th>
                                <th>Info</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1;
                            foreach ($row as $key => $data) { ?>
                                <tr>
                                    <td style="width:5%;"><?= $no++ ?>.</td>
                                    <td><?= $data->item_name ?></td>
                                    <td class="text-right"><?= $data->qty ?></td>
                                    <td><?= $data->detail ?></td>
                                    <td class="text-center"><?= indo_date($data->date) ?></td>
                                    <td class="text-center" width="160px">
                                        <a href="<?= site_url('transaction/stock/out/del/' . $data->stock_id . '/' . $data->item_id) ?>" onclick="return confirm('Yakin hapus data?')" class="btn btn-danger btn-xs">
                                            <i class="fa fa-trash"></i> Delete
                                        </a>
                                    </td>
                                </tr>
                            <?php
                            } ?>
                        </tbody>
                    </table>
                </div>
            </div>
</section>