    <!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?= site_url('Transaction/Sales') ?>">Sales</a></li>
                    <li class="breadcrumb-item active">Transaction</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>
<section class="content">
    <?php $this->view('message') ?>
    <div class="row">
        <div class="col-lg-4">
            <div class="card card-widget">
                <div class="card-body">
                    <table width="100%">
                        <tr>
                            <td style="vertical-align: top;">
                                <label for="date">Date
                                </label>
                            </td>
                            <td>
                                <div class="form-group">
                                    <input type="date" id="date" value="<?= date('Y-m-d') ?>" class="form-control" readonly>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td style="vertical-align: top; width:30%">
                                <label for="kasir">Cashier</label>
                            </td>
                            <td>
                                <div class="form-group input-group">
                                    <input type="hidden" id="cashier_id">
                                    <input type="text" id="cashier_name" class="form-control"  autofocus readonly>
                                    <span class="input-group-append">
                                        <button type="button" class="btn btn-outline-warning waves-effect" data-toggle="modal" data-target="#mymodal-karyawan">
                                            <i class="fa fa-search"></i>

                                        </button>
                                    </span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td style="vertical-align: top;">
                                <label for="customer_name"> Customer</label>
                            </td>
                            <td style="vertical-align: top; width:75%">
                                <div class="form-group input-group">
                                    <input type="hidden" id="customer_id">
                                    <input type="text" id="customer_name" class="form-control"  autofocus readonly>
                                    <span class="input-group-append">
                                        <button type="button" class="btn btn-outline-warning waves-effect" data-toggle="modal" data-target="#mymodal-customer">
                                            <i class="fa fa-search"></i>

                                        </button>
                                    </span>
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card card-widget">
                <div class="card-body">
                    <table width="100%">
                        <tr>
                            <td>
                                <label for="product_name"> Product</label>
                            </td>
                            <td colspan="2" style="vertical-align: top; width:75%">
                                <div class="form-group input-group">
                                    <input type="hidden" id="product_id">
                                    <input type="hidden" id="product_price">
                                    <input type="hidden" id="product_stock">
                                    <input type="hidden" id="product_qty_cart">
                                    <input type="text" id="product_name" class="form-control" autofocus readonly>
                                    <span class="input-group-append">
                                        <button type="button" id="product_modal" class="btn btn-outline-warning waves-effect" data-toggle="modal" data-target="#mymodal-product">
                                            <i class="fa fa-search"></i>
                                        </button>
                                    </span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label for="product_qty">Qty</label>
                            </td>
                            <td colspan="2">
                                <div class="form-group">
                                    <input type="number" id="product_qty" value="1" min="1" class="form-control">
                                </div>
                            </td>

                        </tr>
                        <tr>
                            <td>
                                <label for="product_disc">Discount</label>
                            </td>
                            <td colspan="2">
                                <div class="form-group">
                                    <input type="number" id="product_disc" value="0" min="0" max="100" class="form-control">
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                <div class="float-right">
                                    <button type="button" id="add_cart_product" class="btn btn-outline-info btn-rounded waves-effect">
                                        <i class="fa fa-cart-plus"></i> &nbsp; Add Cart
                                    </button>
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card card-widget">
                <div class="card-body">
                    <div class="float-right">
                        <h4>Invoice <b><span id="invoice"><?= $invoice ?></span></b></h4>
                        <h1><b><span class="float-right" id="grand_total2_product" style="font-size:50pt">0</span></b></h1>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card card-widget">
                <div class="card-body table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Product Item</th>
                                <th>Price</th>
                                <th>Qty</th>
                                <th width="15%">Discount / Item</th>
                                <th style="display:none;" width="15%">Sub Total</th>
                                <th style="display:none;" width="15%">Disc Total</th>
                                <th width="10%">Total</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody id="cart_table_product">
                            <?php $this->load->view('Transaction/Cart_data_product'); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-3">
            <div class="card card-widget">
                <div class="card-body">
                    <table width="100%">
                        <tr>
                            <td style="vertical-align: top; width:30%">
                                <label for="sub_total_product">Sub Total</label>
                            </td>
                            <td>
                                <div class="form-group input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-dollar-sign"></i>
                                        </span>
                                    </div>
                                    <input type="number" id="sub_total_product" value="" class="form-control" readonly>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td style="vertical-align: top; width:30%">
                                <label for="discount_product">Total Discount</label>
                            </td>
                            <td>
                                <div class="form-group input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-dollar-sign"></i>
                                        </span>
                                    </div>
                                    <input type="number" id="discount_product" value="" class="form-control" readonly>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td style="vertical-align: top; width:30%">
                                <label for="grand_total_product">Grand Total</label>
                            </td>
                            <td>
                                <div class="form-group input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-dollar-sign"></i>
                                        </span>
                                    </div>
                                    <!-- POINT CUSTOMER -->
                                    <input type="number" id="grand_total_product" value="" class="form-control" readonly>
                                    <input type="hidden" id="point_product" value="" class="form-control" readonly>
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-lg-3">
            <div class="card card-widget">
                <div class="card-body">
                    <table width="100%">
                        <tr>
                            <td style="vertical-align: top; width:30%">
                                <label for="cash_product">Cash</label>
                            </td>
                            <td>
                                <div class="form-group input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-dollar-sign"></i>
                                        </span>
                                    </div>
                                    <input type="number" id="cash_product" value="0" min="0" class="form-control">
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td style="vertical-align: top; width:30%">
                                <label for="change_product">Change</label>
                            </td>
                            <td>
                                <div class="form-group input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-dollar-sign"></i>
                                        </span>
                                    </div>
                                    <input type="number" id="change_product" value="" class="form-control" readonly>
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-lg-3">
            <div class="card ">
                <div class="card-body">
                    <table width="100%">
                        <tr>
                            <td style="vertical-align: top; width:30%">
                                <label for="method_payment">Payment Method</label>
                            </td>
                            <td>
                                <div class="form-group input-group">
                                    <input type="text" id="method_payment" class="form-control"  readonly>
                                    <span class="input-group-append">
                                        <button type="button" class="btn btn-outline-warning waves-effect" data-toggle="modal" data-target="#mymodal-method">
                                            <i class="fa fa-search"></i>
                                        </button>
                                    </span>
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-lg-3">
            <div class="card ">
                <div class="card-body">
                    <table width="100%">
                        <tr>
                            <td style="vertical-align: top;">
                                <label for="note">Note</label>
                            </td>
                            <td width="90%" colspan="2">
                                <div>
                                    <textarea id="note" rows="3" class="form-control"></textarea>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;</td>
                        </tr>
                        <tr>
                            <td> &nbsp;
                            </td>
                            <td> &nbsp;
                            </td>
                            <td class="text-right">
                                <button id="cancel_payment_product" class="btn btn-danger">
                                    <i class="fas fa-trash-alt"></i> Cancel
                                </button>
                                <button id="process_payment_product" class="btn btn-primary">
                                    <i class="far fa-paper-plane"></i> Process
                                </button>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
    </div>
</section>

<!-- Modal Edit Cart -->
<div class="modal fade" id="mymodal-cart-product-edit">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Update Cart Item</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="cartid_product">
                <div class="form-group">
                    <div class="form-group">
                        <label for="product_cart_name">Product Item</label>
                        <input type="text" id="product_cart_name" class="form-control" readonly>
                    </div>
                    <div class="form-group">
                        <label for="product_cart_price">Price</label>
                        <input type="number" id="product_cart_price" min="0" class="form-control" readonly>
                    </div>
                    <div class="row">
                        <div class="col-md-7">
                            <label for="product_cart_qty">Qty</label>
                            <input type="number" id="product_cart_qty" min="1" class="form-control">
                        </div>
                        <div class="col-md-5">
                            <label for="product_cart_stock">Stock Item</label>
                            <input type="number" id="product_cart_stock" class="form-control" readonly>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="product_cart_before">Total before Discount</label>
                        <input type="number" id="product_cart_before" class="form-control" readonly>
                    </div>
                    <div class="form-group">
                        <label for="product_cart_discount">Discount / Item</label>
                        <div class="form-group">
                            <input type="number" id="product_cart_discount" value="0" min="0" max="100" class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="product_cart_total">Total after Discount</label>
                        <input type="number" id="product_cart_total" min="1" class="form-control" readonly>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="pull-right">
                        <button type="button" id="edit_cart_product" class="btn btn-flat btn-primary">
                            <i class="fa fa-paper-plane"></i> Update
                        </button>
                    </div>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
</div>
<!-- /.modal -->

<!-- Modal Select Customer-->
<div class="modal fade" id="mymodal-customer">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Select Customer</h4>
                <button type="button" class="btn btn-outline-primary waves-effect" id="cust_add" data-toggle="modal" data-target="#add-customer">
                    <i class="fa fa-user-plus"></i> <b>Add Customer</b>
                </button>
            </div>
            <div class="modal-body">
                <table id="example5" class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Customer Name</th>
                            <th>Gender</th>
                            <th>Phone</th>
                            <th>Category</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($customer as $c => $data) { ?>
                            <tr>
                                <td><?= $data->name ?> </td>
                                <td><?= $data->gender == 'L' ? "Laki Laki" : "Perempuan" ?> </td>
                                <td><?= $data->phone ?> </td>
                                <td><?= $data->category_name ?> </td>
                                <td class="text-center" style="width:15%">
                                    <button class="btn btn-xs btn-info" id="select_customer" data-id="<?= $data->customer_id ?>" data-customer="<?= $data->name ?>" data-gender="<?= $data->gender ?>">
                                        <i class="fa fa-check">
                                        </i>Select
                                    </button>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-- Modal Add Customer-->
<div class="modal fade" id="add-customer">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add Customer</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="col-md-12">
                    <form action="<?= site_url('Customer/Customer/Process3') ?>" method="post">
                        <div class="form-group ">
                            <label>Customer Name *</label>
                            <input type="hidden" name="id">
                            <input class="form-control" type="text" name="customer_name" required>
                        </div>
                        <div class="form-group ">
                            <label>Gender *</label>
                            <select name="gender" class="form-control custom-select" data-dropdown-css-class="select2-danger" required>
                                <option value="" selected="selected" disabled>SELECT</option>
                                <option value="L"> Laki-Laki</option>
                                <option value="P"> Perempuan</option>
                            </select>
                        </div>
                        <div class="form-group ">
                            <label>Phone *</label>
                            <input class="form-control" type="text" name="phone" value="" required>
                        </div>
                        <div class="form-group ">
                            <label>Category *</label>
                            <select name="category" class="form-control custom-select" required>
                                <option value="" selected="selected" disabled>SELECT</option>
                                <?php foreach ($query_category->result() as $key => $data) { ?>
                                    <option value="<?= $data->category_id ?>"><?= $data->name ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="form-group ">
                            <label>Address *</label>
                            <textarea class="form-control" name="address" required></textarea>
                        </div>
                        <!-- /.card-body -->
                </div>
                <button type="submit" name="add" class="btn btn-primary">Submit </button>
                <button type="reset" class="btn btn-info float-right">Reset</button>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-- Modal Select Cashier-->
<div class="modal fade" id="mymodal-karyawan">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Select Cashier</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table id="example6" class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Cashier Name</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($cashier as $c => $data) { ?>
                            <tr>
                                <td><?= $data->name ?> </td>
                                <td class="text-center" style="width:15%">
                                    <button class="btn btn-xs btn-info" id="select_cashier" data-id="<?= $data->karyawan_id ?>" data-cashier="<?= $data->name ?>">
                                        <i class="fa fa-check">
                                        </i> Select
                                    </button>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-- Modal Select Product-->
<div class="modal fade" id="mymodal-product">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Select Product</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table id="example2" class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Price</th>
                            <th>stock</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($item as $i => $data) { ?>
                            <tr>
                                <td><?= $data->item_name ?> </td>
                                <td class="text-right"><?= indo_currency($data->item_price) ?> </td>
                                <td class="text-right"><?= $data->stock ?> </td>
                                <td class="text-center" style="width:15%">
                                    <button class="btn btn-xs btn-info" id="select_product" data-id="<?= $data->item_id ?>" data-product="<?= $data->item_name ?>" data-item_price="<?= $data->item_price ?>" data-stock="<?= $data->stock ?>">
                                        <i class="fa fa-check">
                                        </i> Select
                                    </button>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-- Modal Select Method -->
<div class="modal fade" id="mymodal-method">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Select Payment Method</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="container">
                <div class="form-group">
                    <div class="items-collection">
                        <div class="modal-body">
                            <table width="100%">
                                <tr>
                                    <td style="vertical-align: top; width:20%">
                                        <label for="tunai">Cash</label>
                                    </td>
                                    <td style="width:20%">
                                        <button type="button" id="tunai" class="btn btn-block btn-primary btn-rounded waves-effect">
                                            Cash
                                        </button>
                                    </td>
                                    <td style="width:20%"><br></td>
                                    <td style="width:20%"><br></td>
                                </tr>
                                <tr>
                                    <td colspan="4"><br></td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="edc">EDC</label>
                                    </td>
                                    <td>
                                        <button type="button" id="bca" class="btn btn-block btn-primary btn-rounded waves-effect">
                                            BCA
                                        </button>
                                    </td>
                                    <td>
                                        <button type="button" id="mandiri" class="btn btn-block btn-primary btn-rounded waves-effect">
                                            Mandiri
                                        </button>
                                    </td>
                                    <td>
                                        <button type="button" id="bni" class="btn btn-block btn-primary btn-rounded waves-effect">
                                            BNI
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                    </td>
                                    <td>
                                        <button type="button" id="bri" class="btn btn-block btn-primary btn-rounded waves-effect">
                                            BRI
                                        </button>
                                    </td>
                                    <td>
                                        <button type="button" id="cimbniaga" class="btn btn-block btn-primary btn-rounded waves-effect">
                                            Cimb Niaga
                                        </button>
                                    </td>
                                    <td>
                                        <button type="button" id="other_edc" class="btn btn-block btn-primary btn-rounded waves-effect">
                                            Other EDC
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="4"><br></td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="sel_inv">Invoice</label>
                                    </td>
                                    <td>
                                        <button type="button" id="inv" class="btn btn-block btn-primary btn-rounded waves-effect">
                                            Invoice
                                        </button>
                                    </td>
                                    <td>
                                        <button type="button" id="endorse" class="btn btn-block btn-primary btn-rounded waves-effect">
                                            Endorse
                                        </button>
                                    </td>
                                    <td>
                                        <button type="button" id="free" class="btn btn-block btn-primary btn-rounded waves-effect">
                                            Free
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="4"><br></td>
                                </tr>
                            </table>
                            <br>
                            <div class="modal-footer">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->