<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Kas Masuk</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">Transaction</li>
                    <li class="breadcrumb-item active">Data Kas Masuk</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<section class="content">
    <?php $this->view('message') ?>
    <div class="container-fluid">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <a href="<?= site_url('Transaction/Kas/masuk_add') ?>" class="btn btn-primary">
                        <i class="fas fa-plus-circle"></i> <b>Kas Masuk</b>
                    </a>
                    <a href="<?= site_url('Transaction/Kas/keluar') ?>" class="btn btn-info float-right">
                        <i class="fa fa-undo"></i> Back
                    </a>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <table id="example2" class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th style="width:10%;">Date</th>
                                <th style="width:15%;">Karyawan</th>
                                <th style="width:20%;">Total</th>
                                <th>Type</th>
                                <th>Keterangan</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1;
                            foreach ($row as $key => $data) { ?>
                                <tr>
                                    <td style="width:5%"><?= $no++ ?> </td>
                                    <td class="text-left"><?= indo_date($data->date) ?> </td>
                                    <td><?= $data->karyawan_name ?> </td>
                                    <td><?= indo_currency($data->total) ?> </td>
                                    <td class="text-left"><?= ucfirst($data->type) ?> </td>
                                    <td class="text-left"><?= $data->keterangan ?> </td>
                                    <td class="text-center" width="160px">
                                        <a href="<?= site_url('Transaction/Kas/masuk_del/' . $data->kas_id) ?>" onclick="return confirm('Yakin hapus data?')" class="btn btn-danger btn-xs">
                                            <i class="fa fa-trash"></i> Delete
                                        </a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->