<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Services</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">Product</li>
                    <li class="breadcrumb-item active">Data Services</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<section class="content">
    <?php $this->view('message') ?>
    <div class="container-fluid">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <a href="<?= site_url('Products/Categories') ?>" class="btn btn-primary">
                        <b> Category Services </b>
                    </a>
                    <a href="<?= site_url('Products/Services/add') ?>" class="btn btn-primary float-right">
                        <i class="fas fa-plus-circle"></i> <b>Add Service</b>
                    </a>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <table id="example2" class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Category</th>
                                <?php if ($this->fungsi->user_login()->level == 1) {  ?>
                                    <th>Modal</th>
                                <?php } ?>
                                <th>Price</th>
                                <th>Commision</th>
                                 <?php if ($this->fungsi->user_login()->level == 1) {  ?>
                                <th>Actions</th>
                                <?php } ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1;
                            foreach ($row->result() as $key => $data) { ?>
                                <tr>
                                    <td style="width:5%"><?= $no++ ?> </td>
                                    <td><?= $data->services_name ?> </td>
                                    <td><?= $data->category_name ?> </td>
                                    <?php if ($this->fungsi->user_login()->level == 1) {  ?>
                                        <td><?= indo_currency($data->services_modal) ?> </td>
                                    <?php } ?>
                                    <td><?= indo_currency($data->services_price) ?> </td>
                                    <td><?= indo_currency($data->commision) ?> </td>
                                    <?php if ($this->fungsi->user_login()->level == 1) {  ?>
                                    <td class="text-center" width="150px">
                                        <a href="<?= site_url('Products/Services/edit/' . $data->services_id) ?>" class="btn btn-primary btn-xs">
                                            <i class=" fa fa-edit"></i><b>Update</b>
                                        </a>
                                        <a href="<?= site_url('Products/Services/del/' . $data->services_id) ?>" class="btn btn-danger btn-xs" onclick="return confirm('Apakah anda yakin?')">
                                                <i class="fa fa-trash"></i><b>Delete</b>
                                            </a>
                                    </td>
                                    <?php } ?>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->