<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Product</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">Product</li>
                    <li class="breadcrumb-item active">Data Product</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>
<section class="content">
    <?php $this->view('message') ?>
    <div class="container-fluid">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <a href="<?= site_url('Transaction/Stock/in') ?>" class="btn btn-primary ">
                        <b>Stock In</b>
                    </a> &nbsp; &nbsp;
                    <a href="<?= site_url('Transaction/Stock/Out') ?>" class="btn btn-primary ">
                        <b>Stock Out</b>
                    </a> &nbsp; &nbsp;
                    <a href="<?= site_url('Products/Item/export_excel') ?>" class="btn btn-warning ">
                        <i class="fas fa-download"></i> <b>Report Stock</b>
                    </a> &nbsp; &nbsp;
                    <button id="export_detail" data-target="#modal-export-in-out" data-toggle="modal" class="btn btn-warning">
                        <i class="fas fa-download"></i> <b>Report In/Out</b>
                    </button>
                    <a href="<?= site_url('Products/Item/add') ?>" class="btn btn-primary float-right">
                        <i class="fas fa-plus-circle"></i> <b>Add Product</b>
                    </a>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <table id="example2" class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Price</th>
                                <th>Stock</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1;
                            foreach ($row->result() as $key => $data) { ?>
                                <tr>
                                    <td style="width:5%"><?= $no++ ?> </td>
                                    <td><?= $data->item_name ?> </td>
                                    <td><?= indo_currency($data->item_price) ?> </td>
                                    <td><?= $data->stock ?> </td>
                                    <td class="text-center" width="150px">
                                        <a href="<?= site_url('Products/Item/edit/' . $data->item_id) ?>" class="btn btn-primary btn-xs">
                                            <i class=" fa fa-edit"></i><b>Update</b>
                                        </a>
                                        <?php if ($this->fungsi->user_login()->level == 1) {  ?>

                                            <a href="<?= site_url('Products/Item/del/' . $data->item_id) ?>" class="btn btn-danger btn-xs" onclick="return confirm('Apakah anda yakin?')">
                                                <i class="fa fa-trash"></i><b>Delete</b>
                                            </a>

                                        <?php } ?>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->
!-- MODAL EXPORT DETAIL DATE -->
<div class="modal fade" id="modal-export-in-out">
    <div class="modal-dialog modal-sm">
        <div class="modal-content bg-warning">
            <div class="modal-header">
                <h4 class="modal-title">Export Report In/Out</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
            </div>
            <form action="<?= site_url('Products/Item/export_excel_in_out') ?>" method="get" target="_blank">
                <div class="modal-body">
                    <div class="col-md-12">
                        <div class="form-group ">
                            <label>From *</label>
                            <input type="date" class="form-control" name="tgl1" required>
                        </div>
                        <div class="form-group ">
                            <label>To *</label>
                            <input type="date" class="form-control" name="tgl2" required>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" value="printexcel" name="printexcel" class="btn btn-outline-dark">Export</button>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->