<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Customer_m extends CI_Model
{

    // menampilkan data customer
    public function get($id = null)
    {
        $this->db->select('customer.*,  c_category.name as category_name');
        $this->db->from('customer');
        $this->db->join('c_category', 'c_category.category_id = customer.category_id');
        if ($id != null) {
            $this->db->where('customer_id', $id);
        }
        $query = $this->db->get();
        return $query;
    }

    // menghapus data customer
    public function del($id)
    {

        $this->db->where('customer_id', $id);
        $this->db->delete('customer');
    }

    // menambah data customer
    public function add($post)
    {
        $params = [
            'name' => $post['customer_name'],
            'gender' => $post['gender'],
            'phone' => $post['phone'],
            'address' => $post['address'],
            'category_id' => $post['category'],
        ];
        $this->db->insert('customer', $params);
    }

    // mengedit data customer
    public function edit($post)
    {
        $params = [
            'name' => $post['customer_name'],
            'gender' => $post['gender'],
            'phone' => $post['phone'],
            'address' => $post['address'],
            'category_id' => $post['category'],
            'updated' => date('Y-m-d H:i:s')
        ];
        $this->db->where('customer_id', $post['id']);
        $this->db->update('customer', $params);
    }

    public function view_customer()
    {
        $this->db->select('*, c_category.name as category_name, customer.name as cust_name ');
        $this->db->from('customer');
        $this->db->join('c_category', 'customer.category_id = c_category.category_id');
        return $this->db->get()->result(); // Tampilkan data transaksi sesuai tanggal yang diinput oleh user pada filter  
    }
}
