<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Stock extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        check_not_login();
        $this->load->model(['Products/Item_m', 'Transaction/Stock_m']);
    }
    // tampil data index
    public function stock_in_data()
    {
        $data['row'] = $this->Stock_m->get_stock_in()->result();
        $this->template->load('template', 'Transaction/Stock_in/Stock_in_data', $data);
        $this->load->view('datatables');
    }
    // tampil data form
    public function stock_in_add()
    {
        $item = $this->Item_m->get()->result();
        $data = ['item' => $item];
        $this->template->load('template', 'Transaction/Stock_in/Stock_in_form', $data);
        $this->load->view('datatables');
    }

    // form delete stock in
    public function stock_in_del()
    {
        $stock_id = $this->uri->segment(5);
        $item_id = $this->uri->segment(6);
        $qty = $this->Stock_m->get($stock_id)->row()->qty;
        $data = ['qty' => $qty, 'item_id' => $item_id];
        $this->Item_m->update_stock_out($data);
        $this->Stock_m->del($stock_id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Stock-In berhasil dihapus');
        }
        redirect('Transaction/Stock/in');
    }


    // FORM PROSES
    public function process()
    {
        if (isset($_POST['in_add'])) {
            $post = $this->input->post(null, TRUE);
            $this->Stock_m->add_stock_in($post);
            $this->Item_m->update_stock_in($post);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Data Stock-In berhasil disimpan');
            }
            redirect('Transaction/Stock/in');
        } else if (isset($_POST['out_add'])) {
            $post = $this->input->post(null, TRUE);
            $row_item = $this->Item_m->get($this->input->post('item_id'))->row();
            if ($row_item->stock < $this->input->post('qty')) {
                $this->session->set_flashdata('error', 'Qty melebihi stock barang');
                redirect('Transaction/Stock/Out/add');
            } else {
                $this->Stock_m->add_stock_out($post);
                $this->Item_m->update_stock_out($post);
                if ($this->db->affected_rows() > 0) {
                    $this->session->set_flashdata('success', 'Data Stock-Out berhasil disimpan');
                }
                redirect('Transaction/Stock/Out');
            }
        }
    }
    // index stock out
    public function stock_out_data()
    {
        $data['row'] = $this->Stock_m->get_stock_out()->result();
        $this->template->load('template', 'Transaction/Stock_Out/stock_out_data', $data);
        $this->load->view('datatables');
    }
    // form tambah stock out
    public function stock_out_add()
    {
        $item = $this->Item_m->get()->result();
        $data = ['item' => $item];
        $this->template->load('template', 'Transaction/Stock_Out/stock_out_form', $data);
        $this->load->view('datatables');
    }
    // del stock out
    public function stock_out_del()
    {
        $stock_id = $this->uri->segment(5);
        $item_id = $this->uri->segment(6);
        $qty = $this->Stock_m->get($stock_id)->row()->qty;
        $data = ['qty' => $qty, 'item_id' => $item_id];
        $this->Item_m->update_stock_in($data);
        $this->Stock_m->del($stock_id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Stock-Out berhasil dihapus');
        }
        redirect('Transaction/Stock/Out');
    }
}
