<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Sales_item extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        check_not_login();
        $this->load->model('Transaction/Sales_m');
    }
    // VIEW DATA INDEX
    public function index()
    {
        check_kasir();
        $this->load->model(['Customer/Customer_m', 'Customer/C_Category_m', 'Products/Item_m', 'Karyawan_m']);
        $customer = $this->Customer_m->get()->result();
        $query_category = $this->C_Category_m->get();
        $cashier = $this->Karyawan_m->get_cashier()->result();
        $item = $this->Item_m->get()->result();
        $cart = $this->Sales_m->get_cart_product();
        $data = array(
            'customer' => $customer,
            'cashier' => $cashier,
            'item' => $item,
            'query_category' => $query_category,
            'cart' => $cart,
            'invoice' => $this->Sales_m->invoice_no_item(),
        );
        $this->template->load('template', 'Transaction/Sales_form_item', $data);
        $this->load->view('datatables');
    }
    // END DATA INDEX

    // PROCESS ADD/EDIT/PAYMENT
    public function process()
    {
        $data = $this->input->post(null, TRUE);

        if (isset($_POST['add_cart_product'])) {
            $this->Sales_m->add_cart_product($data);
            if ($this->db->affected_rows() > 0) {
                $params = array("success" => true);
            } else {
                $params = array("success" => false);
            }
            echo json_encode($params);
        }
        if (isset($_POST['edit_cart_product'])) {
            $this->Sales_m->edit_cart_product($data);
            if ($this->db->affected_rows() > 0) {
                $params = array("success" => true);
            } else {
                $params = array("success" => false);
            }
            echo json_encode($params);
        }
        if (isset($_POST['process_payment_item'])) {
            $sale_id = $this->Sales_m->add_sale_item($data);
            $cart = $this->Sales_m->get_cart_product()->result();
            $row = [];
            foreach ($cart as $c => $value) {
                array_push(
                    $row,
                    array(
                        'sale_id' => $sale_id,
                        'item_id' => $value->item_id,
                        'detail_price' => $value->cart_price,
                        'qty' => $value->qty,
                        'discount_item' => $value->discount_item,
                        'total' => $value->total,
                    )
                );
            }
            $this->Sales_m->add_sale_detail_item($row);
            $this->Sales_m->del_cart_product(['user_id' => $this->session->userdata('user_id')]);
            if ($this->db->affected_rows() > 0) {
                $params = array("success" => true, "sale_id" => $sale_id);
            } else {
                $params = array("success" => false);
            }
            echo json_encode($params);
        }
    }

    function cart_data_product()
    {
        $cart = $this->Sales_m->get_cart_product();
        $data['cart'] = $cart;
        $this->load->view('Transaction/Cart_data_product', $data);
    }

    // DELETE CART PRODUCT
    public function cart_del_product()
    {
        if (isset($_POST['cancel_payment_product'])) {
            $this->Sales_m->del_cart_product(['user_id' => $this->session->userdata('user_id')]);
        } else {
            $cart_id = $this->input->post('cart_id');
            $this->Sales_m->del_cart_product(['cart_id' => $cart_id]);
        }
        if ($this->db->affected_rows() > 0) {
            $params = array("success" => true);
        } else {
            $params = array("success" => false);
        }
        echo json_encode($params);
    }

    // CETAK CART PRODUCT
    public function cetak_item($id)
    {
        $data = array(
            'sale' => $this->Sales_m->get_sale_item($id)->row(),
            'sale_detail' => $this->Sales_m->get_sale_detail_item($id)->result(),
        );
        $this->load->view('Transaction/Receipt_print_item', $data);
    }

    // DELETE REPORT SALE PRODUCT
    public function del($id)
    {
        $this->Sales_m->del_sale_item($id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil Dihapus');
            redirect('Report/Report_item');
        } else {
            $this->session->set_flashdata('error', 'Data Gagal Dihapus');
            redirect('Report/Report_item');
        }
    }
}
