<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Catatankerja extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        check_not_login();
        $this->load->model(['Karyawan_m', 'Rpotkaryawan/Catatankerja_m']);
    }

    // INDEX CATATAN
    public function index()
    {
        $data['row'] = $this->Catatankerja_m->get_catatan()->result();
        $this->template->load('template', 'RpotKaryawan/CatatanKerja/catatankerja_data', $data);
        $this->load->view('datatables');
    }

    // SELECT KARYAWAN/CUSTOMER KELUHAN FORM
    public function catatan_add()
    {
        $karyawan = $this->Karyawan_m->get()->result();
        $data = ['karyawan' => $karyawan];
        $this->template->load('template', 'RpotKaryawan/CatatanKerja/catatankerja_form', $data);
        $this->load->view('datatables');
    }

    // FORM PROSES
    public function process()
    {
        if (isset($_POST['catatan_add'])) {
            $post = $this->input->post(null, TRUE);
            $this->Catatankerja_m->add_catatan($post);
            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('success', 'Data berhasil disimpan');
            }
            redirect('Rpotkaryawan/Catatankerja');
        }
    }

    public function del($id)
    {
        $this->Catatankerja_m->del($id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil Dihapus');
        }
        redirect('Rpotkaryawan/Catatankerja');
    }
}
