<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		check_not_login();
		$this->load->model('dashboard_m');
		$this->load->helper('date');
	}

	public function index()
	{
		if (isset($_GET['cetak']) && !empty($_GET['cetak'])) {
			$tgl1 = $_GET['tgl1'];
			$tgl2 = $_GET['tgl2'];
// GRAFIK
			$data['row'] = $this->dashboard_m->product_laris();
			$data['stock'] = $this->dashboard_m->stock_product();
// END GRAFIK
// COUNT TOTAL CUST/PRODUCT/TREATMENT
			$data['count_cust'] = $this->dashboard_m->num_customer_filter($tgl1, $tgl2);
			$data['count_product'] = $this->dashboard_m->num_product_filter($tgl1, $tgl2);
			$data['count_treatment'] = $this->dashboard_m->num_treatment_filter($tgl1, $tgl2);
// END COUNT

// FINAL PRICE
			$data['treatment'] = $this->dashboard_m->final_treatment_filter($tgl1, $tgl2);
			$data['product'] = $this->dashboard_m->final_product_filter($tgl1, $tgl2);
// END FINAL PRICE

			$data['hpp'] = $this->dashboard_m->count_tot_hpp_filter($tgl1, $tgl2);
			
// TOTAL BELUM DISCOUNT
			$data['sub_treatment'] = $this->dashboard_m->sub_treatment_filter($tgl1, $tgl2);
			$data['sub_product'] = $this->dashboard_m->sub_product_filter($tgl1, $tgl2);
// END TOTAL BELU< DISCOUNT

// FINAL TOTAL KAS
			$data['sub_kas_masuk'] = $this->dashboard_m->sub_kas_masuk_filter($tgl1, $tgl2);
			$data['sub_kas_keluar'] = $this->dashboard_m->sub_kas_keluar_filter($tgl1, $tgl2);
// END FINAL TOTAL KAS

			// EDC
			$data['sub_treatment_bni'] = $this->dashboard_m->sub_treatment_bni_filter($tgl1, $tgl2);
			$data['sub_product_bni'] = $this->dashboard_m->sub_product_bni_filter($tgl1, $tgl2);
			$data['sub_treatment_bca'] = $this->dashboard_m->sub_treatment_bca_filter($tgl1, $tgl2);
			$data['sub_product_bca'] = $this->dashboard_m->sub_product_bca_filter($tgl1, $tgl2);
			$data['sub_treatment_mandiri'] = $this->dashboard_m->sub_treatment_mandiri_filter($tgl1, $tgl2);
			$data['sub_product_mandiri'] = $this->dashboard_m->sub_product_mandiri_filter($tgl1, $tgl2);
			$data['sub_treatment_cash'] = $this->dashboard_m->sub_treatment_cash_filter($tgl1, $tgl2);
			$data['sub_product_cash'] = $this->dashboard_m->sub_product_cash_filter($tgl1, $tgl2);
			// END EDC

			$data['include'] = $data['product'] + $data['treatment'];
			
			$data['gross_sale'] = $data['sub_product'] + $data['sub_treatment'];
			$data['gross_profit'] = $data['sub_treatment'] - $data['hpp'];
			
			$data['edc_bni'] = $data['sub_product_bni'] + $data['sub_treatment_bni'];
			$data['edc_bca'] = $data['sub_product_bca'] + $data['sub_treatment_bca'];
			$data['edc_mandiri'] = $data['sub_product_mandiri'] + $data['sub_treatment_mandiri'];
			$data['cash'] = ($data['sub_product_cash'] + $data['sub_treatment_cash']) - ($data['sub_kas_keluar'] - $data['sub_kas_masuk']);
			

			$this->template->load('template', 'dashboard', $data);
		} else {
			$data['stock'] = $this->dashboard_m->stock_product();
			$data['row'] = $this->dashboard_m->product_laris();
			$data['count_cust'] = $this->dashboard_m->num_customer();
			$data['count_product'] = $this->dashboard_m->num_product();
			$data['count_treatment'] = $this->dashboard_m->num_treatment();
			$data['treatment'] = $this->dashboard_m->final_treatment();
			$data['product'] = $this->dashboard_m->final_product();
			$data['hpp'] = $this->dashboard_m->count_tot_hpp();
			$data['sub_treatment'] = $this->dashboard_m->sub_treatment();
			$data['sub_product'] = $this->dashboard_m->sub_product();
			$data['sub_kas_masuk'] = $this->dashboard_m->sub_kas_masuk();
			$data['sub_kas_keluar'] = $this->dashboard_m->sub_kas_keluar();

			// EDC
			$data['sub_treatment_bni'] = $this->dashboard_m->sub_treatment_bni();
			$data['sub_product_bni'] = $this->dashboard_m->sub_product_bni();
			$data['sub_treatment_bca'] = $this->dashboard_m->sub_treatment_bca();
			$data['sub_product_bca'] = $this->dashboard_m->sub_product_bca();
			$data['sub_treatment_mandiri'] = $this->dashboard_m->sub_treatment_mandiri();
			$data['sub_product_mandiri'] = $this->dashboard_m->sub_product_mandiri();
			$data['sub_treatment_cash'] = $this->dashboard_m->sub_treatment_cash();
			$data['sub_product_cash'] = $this->dashboard_m->sub_product_cash();
			// END EDC

			// EDC
			$data['edc_bni'] = $data['sub_product_bni'] + $data['sub_treatment_bni'];
			$data['edc_bca'] = $data['sub_product_bca'] + $data['sub_treatment_bca'];
			$data['edc_mandiri'] = $data['sub_product_mandiri'] + $data['sub_treatment_mandiri'];
			$data['cash'] = ($data['sub_product_cash'] + $data['sub_treatment_cash']) - ($data['sub_kas_keluar'] - $data['sub_kas_masuk']);
			// END EDC
			$data['include'] = $data['product'] + $data['treatment'];
			$data['gross_sale'] = $data['sub_product'] + $data['sub_treatment'];
			$data['gross_profit'] = $data['sub_treatment'] - $data['hpp'];
			$this->template->load('template', 'dashboard', $data);
		}
	}
}
