<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Bahan extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        check_not_login();
        $this->load->model('Bahan/Bahan_m');
    }

    public function index()
    {
        $data['row'] = $this->Bahan_m->get();
        $this->template->load('template', 'Bahan/Bahan_data', $data);
        $this->load->view('datatables');
    }
    // FORM ADD
    public function add()
    {
        $Bahan = new stdClass();
        $Bahan->bahan_id = null;
        $Bahan->bahan_name = null;
        $data = array(
            'page' => 'add',
            'row' => $Bahan,
        );
        $this->template->load('template', 'Bahan/Bahan_form', $data);
    }

    // form edit
    public function edit($id)
    {
        $query = $this->Bahan_m->get($id);
        if ($query->num_rows() > 0) {
            $Bahan = $query->row();
            $data = array(
                'page' => 'edit',
                'row' => $Bahan,
            );
            $this->template->load('template', 'Bahan/Bahan_form', $data);
        } else {
            echo "<script>alert('Data tidak dBahanukan');";
            echo "window.location='" . site_url('Bahan/Bahan') . "';</script>";
        }
    }

    // FORM PROSES
    public function process()
    {
        $post = $this->input->post(null, True);
        if (isset($_POST['add'])) {
            $this->Bahan_m->add($post);
        } else if (isset($_POST['edit'])) {
            $this->Bahan_m->edit($post);
        }
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil Disimpan');
        }
        redirect('Bahan/Bahan');
    }
    // FORM DELETE
    public function del($id)
    {
        $this->Bahan_m->del($id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Berhasil DiHapus');
        }
        redirect('Bahan/Bahan');
    }

    public function export_excel()
    {
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel.php';
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->getProperties()->setCreator("Podiy Beauty");
        $objPHPExcel->getProperties()->setLastModifiedBy("Podiy Beauty");
        $objPHPExcel->getProperties()->setTitle("Data Stock Product");
        $objPHPExcel->getProperties()->setSubject("");
        $objPHPExcel->getProperties()->setDescription("");

        $style_col = array(
            'font' => array('bold' => true),
            'aligment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
            ),
            'borders' => array(
                'top' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'right' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'left' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
            )
        );

        $product = $this->Bahan_m->view_stock(); // Panggil fungsi view_by_date yang ada di TransaksiModel            

        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A1', "DATA STOCK ITEM");
        $objPHPExcel->getActiveSheet()->mergeCells('A1:C1');
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->setCellValue('A2', "No");
        $objPHPExcel->getActiveSheet()->setCellValue('B2', "Item Name");
        $objPHPExcel->getActiveSheet()->setCellValue('C2', "Stock");

        $objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('C2')->applyFromArray($style_col);

        $baris = 3;
        $x = 1;
        foreach ($product as $data) {
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $baris, $x);
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $baris, $data->bahan_name);
            $objPHPExcel->getActiveSheet()->setCellValue('C' . $baris, $data->stock);

            $x++;
            $baris++;
        }
        $filename = "Data_stock_item".".xlsx";
        $objPHPExcel->getActiveSheet()->setTitle("Data Stock Bahan");

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename=' . $filename);
        header('Cache-Control: max-age=0');

        $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $writer->save('php://output');

        exit;
    }
    
    public function export_excel_in_out()
    {
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel.php';
        include APPPATH . 'third_party/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->getProperties()->setCreator("Podiy Beauty");
        $objPHPExcel->getProperties()->setLastModifiedBy("Podiy Beauty");
        $objPHPExcel->getProperties()->setTitle("Data Stock In/Out Item");
        $objPHPExcel->getProperties()->setSubject("");
        $objPHPExcel->getProperties()->setDescription("");

        $style_col = array(
            'font' => array('bold' => true),
            'aligment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
            ),
            'borders' => array(
                'top' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'right' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
                'left' => array('style' => PHPExcel_Style_Border::BORDER_THIN),
            )
        );
        
        if (isset($_GET['printexcel']) && !empty($_GET['printexcel'])) { // Cek apakah user telah memilih filter dan klik tombol tampilkan           
            $tgl1 = $_GET['tgl1'];
            $tgl2 = $_GET['tgl2'];
            $product = $this->Bahan_m->view_stock_in_out($tgl1, $tgl2); // Panggil fungsi view_by_date yang ada di TransaksiModel            
        }
      

        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A1', "DATA STOCK IN/OUT ITEM");
        $objPHPExcel->getActiveSheet()->mergeCells('A1:F1');
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->setCellValue('A2', "No");
        $objPHPExcel->getActiveSheet()->setCellValue('B2', "Date");
        $objPHPExcel->getActiveSheet()->setCellValue('C2', "Item Name");
        $objPHPExcel->getActiveSheet()->setCellValue('D2', "Type");
        $objPHPExcel->getActiveSheet()->setCellValue('E2', "Qty");
        $objPHPExcel->getActiveSheet()->setCellValue('F2', "Detail");

        $objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('C2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('D2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('E2')->applyFromArray($style_col);
        $objPHPExcel->getActiveSheet()->getStyle('F2')->applyFromArray($style_col);

        $baris = 3;
        $x = 1;
        foreach ($product as $data) {
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $baris, $x);
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $baris, $data->date);
            $objPHPExcel->getActiveSheet()->setCellValue('C' . $baris, $data->bahan_name);
            $objPHPExcel->getActiveSheet()->setCellValue('D' . $baris, $data->type);
            $objPHPExcel->getActiveSheet()->setCellValue('E' . $baris, $data->qty);
            $objPHPExcel->getActiveSheet()->setCellValue('F' . $baris, $data->detail);

            $x++;
            $baris++;
        }
        $filename = "Data_in_out_item".".xlsx";
        $objPHPExcel->getActiveSheet()->setTitle("Data In Out Item");

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename=' . $filename);
        header('Cache-Control: max-age=0');

        $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $writer->save('php://output');

        exit;
    }
}
